/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.listeners;

import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import io.papermc.paper.event.block.BlockBreakBlockEvent;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.ChiseledBookshelf;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.block.data.type.Piston;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockReceiveGameEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.event.LockBlockEvent;
import org.popcraft.bolt.listeners.InteractionListener;
import org.popcraft.bolt.listeners.adapter.ConnectedShelves;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceResolver;
import org.popcraft.bolt.source.SourceTypeResolver;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.Doors;
import org.popcraft.bolt.util.Mode;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.ProtectableConfig;
import org.popcraft.bolt.util.Protections;
import org.popcraft.bolt.util.SchedulerUtil;

public final class BlockListener
extends InteractionListener
implements Listener {
    private static final SourceResolver BLOCK_SOURCE_RESOLVER = new SourceTypeResolver(Source.of("block"));
    private static final SourceResolver REDSTONE_SOURCE_RESOLVER = new SourceTypeResolver(Source.of("redstone"));
    private static final Set<Material> DYES = Set.of(Material.WHITE_DYE, Material.ORANGE_DYE, Material.MAGENTA_DYE, Material.LIGHT_BLUE_DYE, Material.YELLOW_DYE, Material.LIME_DYE, Material.PINK_DYE, Material.GRAY_DYE, Material.LIGHT_GRAY_DYE, Material.CYAN_DYE, Material.PURPLE_DYE, Material.BLUE_DYE, Material.BROWN_DYE, Material.GREEN_DYE, Material.RED_DYE, Material.BLACK_DYE);
    private static final Tag<Material> WOODEN_SHELVES = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)"wooden_shelves"), Material.class);

    public BlockListener(BoltPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (Action.LEFT_CLICK_AIR.equals((Object)e.getAction()) || Action.RIGHT_CLICK_AIR.equals((Object)e.getAction()) || Action.PHYSICAL.equals((Object)e.getAction())) {
            return;
        }
        Block clicked = e.getClickedBlock();
        if (clicked == null) {
            return;
        }
        Player player = e.getPlayer();
        BoltPlayer boltPlayer = this.plugin.player(player);
        if (boltPlayer.hasInteracted()) {
            if (boltPlayer.isInteractionCancelled()) {
                e.setCancelled(true);
            }
            return;
        }
        Protection protection = this.plugin.findProtection(clicked);
        boolean shouldCancel = false;
        if (this.triggerAction(player, protection, clicked)) {
            boltPlayer.setInteracted(true);
            SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, boltPlayer::clearInteraction);
            shouldCancel = true;
        } else if (protection != null) {
            BlockState blockState;
            boolean hasNotifyPermission = player.hasPermission("bolt.protection.notify");
            boolean canInteract = this.plugin.canAccess(protection, player, "interact");
            if (canInteract && protection instanceof BlockProtection) {
                BlockProtection blockProtection = (BlockProtection)protection;
                protection.setAccessed(System.currentTimeMillis());
                this.plugin.saveProtection(blockProtection);
            }
            if (!canInteract) {
                shouldCancel = true;
                if (!hasNotifyPermission) {
                    BoltComponents.sendMessage((CommandSender)player, "locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                }
            }
            if (this.plugin.isDoors() && canInteract) {
                Doors.handlePlayerInteract(this.plugin, e);
            }
            if (hasNotifyPermission) {
                Profiles.findOrLookupProfileByUniqueId(protection.getOwner()).thenAccept(profile -> {
                    String owner;
                    boolean noSpam = this.plugin.player(player.getUniqueId()).hasMode(Mode.NOSPAM);
                    if (noSpam) {
                        return;
                    }
                    boolean isYou = player.getUniqueId().equals(protection.getOwner());
                    String string = owner = isYou ? BoltComponents.translateRaw("you", (CommandSender)player) : profile.name();
                    if (owner == null) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> {
                            if (!this.plugin.isProtected(clicked)) {
                                return;
                            }
                            BoltComponents.sendMessage((CommandSender)player, "protection_notify_generic", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
                        });
                    } else if (!isYou || player.hasPermission("bolt.protection.notify.self")) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> {
                            if (!this.plugin.isProtected(clicked)) {
                                return;
                            }
                            BoltComponents.sendMessage((CommandSender)player, "protection_notify", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player)), Placeholder.component((String)"player", (ComponentLike)Component.text((String)owner))});
                        });
                    }
                });
            }
            if (e.getItem() != null) {
                Material itemType = e.getItem().getType();
                if (Material.LECTERN.equals((Object)clicked.getType()) && (Material.WRITABLE_BOOK.equals((Object)itemType) || Material.WRITTEN_BOOK.equals((Object)itemType)) && !this.plugin.canAccess(protection, player, "deposit")) {
                    e.setUseItemInHand(Event.Result.DENY);
                } else if (Tag.SIGNS.isTagged((Keyed)clicked.getType()) && (DYES.contains(itemType) || Material.GLOW_INK_SAC.equals((Object)itemType)) && !this.plugin.canAccess(protection, player, "interact")) {
                    e.setUseItemInHand(Event.Result.DENY);
                    e.setUseInteractedBlock(Event.Result.DENY);
                }
            }
            if (Material.CHISELED_BOOKSHELF.equals((Object)clicked.getType()) && (blockState = clicked.getState()) instanceof org.bukkit.block.ChiseledBookshelf) {
                int slot;
                boolean isOccupied;
                Vector clickedPosition;
                ChiseledBookshelf chiseledBookshelfBlockData;
                org.bukkit.block.ChiseledBookshelf chiseledBookshelf = (org.bukkit.block.ChiseledBookshelf)blockState;
                blockState = clicked.getBlockData();
                if (blockState instanceof ChiseledBookshelf && (chiseledBookshelfBlockData = (ChiseledBookshelf)blockState).getFacing() == e.getBlockFace() && (clickedPosition = e.getClickedPosition()) != null && (!(isOccupied = chiseledBookshelfBlockData.isSlotOccupied(slot = chiseledBookshelf.getSlot(clickedPosition))) && !this.plugin.canAccess(protection, player, "deposit") || isOccupied && !this.plugin.canAccess(protection, player, "withdraw"))) {
                    e.setUseItemInHand(Event.Result.DENY);
                    e.setUseInteractedBlock(Event.Result.DENY);
                }
            }
            if (Material.DECORATED_POT.equals((Object)clicked.getType()) && e.getItem() != null && !this.plugin.canAccess(protection, player, "deposit")) {
                e.setUseItemInHand(Event.Result.DENY);
                e.setUseInteractedBlock(Event.Result.DENY);
            }
            boltPlayer.setInteracted(shouldCancel);
            SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, boltPlayer::clearInteraction);
        }
        if (WOODEN_SHELVES != null && WOODEN_SHELVES.isTagged((Keyed)clicked.getType()) && ConnectedShelves.canUse()) {
            List<Block> connected = ConnectedShelves.connectedShelves(clicked);
            for (Block shelf : connected) {
                BlockProtection shelfProtection = this.plugin.loadProtection(shelf);
                if (this.plugin.canAccess((Protection)shelfProtection, player, "deposit", "withdraw")) continue;
                e.setUseItemInHand(Event.Result.DENY);
                e.setUseInteractedBlock(Event.Result.DENY);
            }
        }
        if (shouldCancel) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        BlockState replaced = e.getBlockReplacedState();
        if (replaced.getType().isAir()) {
            return;
        }
        Block block = replaced.getBlock();
        Protection protection = this.plugin.findProtection(block);
        if (protection == null) {
            return;
        }
        if (Tag.REPLACEABLE.isTagged((Keyed)e.getBlockReplacedState().getType())) {
            e.setCancelled(true);
        } else if (!this.plugin.canAccess(block, e.getPlayer(), "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlaceMonitor(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        if (this.plugin.player(player.getUniqueId()).hasMode(Mode.NOLOCK)) {
            return;
        }
        Block block = e.getBlock();
        if (!this.plugin.isProtectable(block)) {
            return;
        }
        ProtectableConfig protectableConfig = this.plugin.getProtectableConfig(block);
        if (protectableConfig == null) {
            return;
        }
        if (protectableConfig.autoProtectPermission() && !player.hasPermission("bolt.protection.autoprotect.%s".formatted(block.getType().name().toLowerCase()))) {
            return;
        }
        Access access = protectableConfig.defaultAccess();
        if (access == null) {
            return;
        }
        if (access.restricted() && !player.hasPermission("bolt.type.protection.%s".formatted(access.type()))) {
            return;
        }
        if (this.plugin.isProtected(block)) {
            return;
        }
        LockBlockEvent event = new LockBlockEvent(player, block, true);
        this.plugin.getEventBus().post(event);
        if (event.isCancelled()) {
            return;
        }
        BlockProtection newProtection = this.plugin.createProtection(block, player.getUniqueId(), access.type());
        this.plugin.saveProtection(newProtection);
        if (!this.plugin.player(player.getUniqueId()).hasMode(Mode.NOSPAM)) {
            BoltComponents.sendMessage((CommandSender)player, "click_locked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(newProtection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(block, (CommandSender)player))});
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (!this.plugin.canAccess(e.getBlock(), e.getPlayer(), "destroy")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreakMonitor(BlockBreakEvent e) {
        Block block = e.getBlock();
        Protection protection = this.plugin.findProtection(block);
        Player player = e.getPlayer();
        if (!(protection instanceof BlockProtection)) {
            return;
        }
        BlockProtection blockProtection = (BlockProtection)protection;
        if (this.plugin.getChestMatcher().canMatch(block)) {
            Block newBlock;
            if (!this.plugin.isProtectedExact(block)) {
                return;
            }
            Match match = this.plugin.getChestMatcher().findMatch(block);
            Block block2 = newBlock = match == null ? null : (Block)match.blocks().stream().findAny().orElse(null);
            if (newBlock != null) {
                blockProtection.setX(newBlock.getX());
                blockProtection.setY(newBlock.getY());
                blockProtection.setZ(newBlock.getZ());
                this.plugin.saveProtection(blockProtection);
                return;
            }
        }
        this.plugin.removeProtection(protection);
        if (!this.plugin.player(player.getUniqueId()).hasMode(Mode.NOSPAM)) {
            BoltComponents.sendMessage((CommandSender)player, "click_unlocked", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Protections.protectionType(protection, (CommandSender)player)), Placeholder.component((String)"protection", (ComponentLike)Protections.displayType(protection, (CommandSender)player))});
        }
    }

    @EventHandler
    public void onPlayerInteractPhysical(PlayerInteractEvent e) {
        if (!Action.PHYSICAL.equals((Object)e.getAction())) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        boolean isPressurePlate = Tag.PRESSURE_PLATES.isTagged((Keyed)block.getType());
        String[] stringArray = new String[1];
        String string = stringArray[0] = isPressurePlate ? "interact" : "destroy";
        if (!this.plugin.canAccess(block, e.getPlayer(), stringArray)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        if (!this.plugin.canAccess(e.getBlock(), e.getPlayer(), "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent e) {
        Block growingBlock = e.getLocation().getBlock();
        if (this.plugin.isProtected(growingBlock)) {
            e.setCancelled(true);
            return;
        }
        e.getBlocks().removeIf(blockState -> this.plugin.isProtected(blockState.getBlock()));
    }

    @EventHandler
    public void onBlockMultiPlace(BlockMultiPlaceEvent e) {
        if (WOODEN_SHELVES != null && WOODEN_SHELVES.isTagged((Keyed)e.getBlock().getType())) {
            for (BlockState blockState : e.getReplacedBlockStates()) {
                Protection protection = this.plugin.findProtection(blockState.getBlock());
                if (this.plugin.canAccess(protection, e.getPlayer(), "destroy")) continue;
                e.setCancelled(true);
                return;
            }
        } else {
            for (BlockState blockState : e.getReplacedBlockStates()) {
                if (!this.plugin.isProtected(blockState.getBlock())) continue;
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent e) {
        if (this.plugin.isProtected(e.getToBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent e) {
        if (this.plugin.isProtected(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPistonRetract(BlockPistonRetractEvent e) {
        for (Block block : e.getBlocks()) {
            if (!this.plugin.isProtected(block)) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockPistonExtend(BlockPistonExtendEvent e) {
        BlockProtection pistonProtection = this.plugin.loadProtection(e.getBlock());
        List blocks = e.getBlocks();
        for (Block block : blocks) {
            boolean canBreak;
            Protection blockProtection = this.plugin.findProtection(block);
            if (blockProtection == null || (canBreak = pistonProtection != null && block.getPistonMoveReaction() == PistonMoveReaction.BREAK && this.plugin.canAccess(blockProtection, pistonProtection.getOwner(), "destroy"))) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent e) {
        e.blockList().removeIf(this.plugin::isProtected);
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent e) {
        e.blockList().removeIf(this.plugin::isProtected);
    }

    @EventHandler
    public void onSpongeAbsorb(SpongeAbsorbEvent e) {
        if (this.plugin.isProtected(e.getBlock())) {
            e.setCancelled(true);
            return;
        }
        e.getBlocks().removeIf(blockState -> this.plugin.isProtected(blockState.getBlock()));
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent e) {
        Protection protection = this.plugin.findProtection(e.getBlock());
        if (protection == null) {
            return;
        }
        Player player = e.getPlayer();
        if (player == null || !this.plugin.canAccess(protection, player, "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent e) {
        Protection protection = this.plugin.findProtection(e.getBlock());
        if (protection == null) {
            return;
        }
        Player player = e.getPlayer();
        if (e.getBlock().equals((Object)e.getBlockClicked()) && Tag.CAULDRONS.isTagged((Keyed)e.getBlock().getType())) {
            if (!this.plugin.canAccess(protection, player, "interact", "deposit")) {
                e.setCancelled(true);
            }
        } else if (!e.getBlock().equals((Object)e.getBlockClicked())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerBucketFill(PlayerBucketFillEvent e) {
        Protection protection = this.plugin.findProtection(e.getBlock());
        if (protection == null) {
            return;
        }
        Player player = e.getPlayer();
        if (e.getBlock().equals((Object)e.getBlockClicked()) && Tag.CAULDRONS.isTagged((Keyed)e.getBlock().getType()) && !this.plugin.canAccess(protection, player, "interact", "withdraw")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockForm(BlockFormEvent e) {
        if (this.plugin.isProtected(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockSpread(BlockSpreadEvent e) {
        if (this.plugin.isProtected(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent e) {
        Block block = e.getBlock();
        if (this.plugin.isProtected(e.getBlock())) {
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Leaves) {
                Leaves leaves = (Leaves)blockData;
                leaves.setPersistent(true);
            }
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockRedstone(BlockRedstoneEvent e) {
        Protection protection = this.plugin.findProtection(e.getBlock());
        if (protection == null) {
            return;
        }
        if (!this.plugin.canAccess(protection, REDSTONE_SOURCE_RESOLVER, "redstone")) {
            e.setNewCurrent(e.getOldCurrent());
        }
    }

    @EventHandler
    public void onPlayerTakeLecternBook(PlayerTakeLecternBookEvent e) {
        if (!this.plugin.canAccess(e.getLectern().getBlock(), e.getPlayer(), "withdraw")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerRecipeBookClick(PlayerRecipeBookClickEvent e) {
        Player player = e.getPlayer();
        Location location = player.getOpenInventory().getTopInventory().getLocation();
        if (location != null && !this.plugin.canAccess(location.getBlock(), player, "deposit", "withdraw")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockDispense(BlockDispenseEvent e) {
        Block block = e.getBlock();
        Protection existingProtection = this.plugin.findProtection(block);
        if (existingProtection == null) {
            return;
        }
        if (!this.plugin.canAccess(existingProtection, REDSTONE_SOURCE_RESOLVER, "redstone")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDispenseMonitor(BlockDispenseEvent e) {
        BlockData blockData;
        Block block = e.getBlock();
        Protection existingProtection = this.plugin.findProtection(block);
        if (existingProtection == null) {
            return;
        }
        Material placingType = e.getItem().getType();
        if (Tag.SHULKER_BOXES.isTagged((Keyed)placingType) && this.plugin.isProtectable(placingType) && (blockData = block.getBlockData()) instanceof Directional) {
            Directional directional = (Directional)blockData;
            Block placeTo = block.getRelative(directional.getFacing());
            if (!placeTo.getType().isAir()) {
                return;
            }
            BlockProtection newProtection = this.plugin.createProtection(placeTo, existingProtection.getOwner(), existingProtection.getType());
            newProtection.setBlock(placingType.name());
            this.plugin.saveProtection(newProtection);
        }
    }

    @EventHandler
    public void onBlockDispenseArmorEvent(BlockDispenseArmorEvent e) {
        Protection entityProtection = this.plugin.findProtection((Entity)e.getTargetEntity());
        if (entityProtection == null) {
            return;
        }
        Protection blockProtection = this.plugin.findProtection(e.getBlock());
        if (blockProtection != null && !this.plugin.canAccess(entityProtection, blockProtection.getOwner(), "interact")) {
            e.setCancelled(true);
        } else if (blockProtection == null && !this.plugin.canAccess(entityProtection, BLOCK_SOURCE_RESOLVER, "interact")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPreDispense(BlockPreDispenseEvent e) {
        Block block = e.getBlock();
        Protection existingProtection = this.plugin.findProtection(block);
        if (existingProtection == null) {
            return;
        }
        if (!this.plugin.canAccess(existingProtection, REDSTONE_SOURCE_RESOLVER, "redstone")) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockDestroy(BlockDestroyEvent e) {
        Block block = e.getBlock();
        Protection existingProtection = this.plugin.findProtection(block);
        if (existingProtection == null) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreakBlock(BlockBreakBlockEvent e) {
        Block target = e.getBlock();
        Protection targetProtection = this.plugin.findProtection(target);
        if (e.getSource().getBlockData() instanceof Piston && targetProtection != null) {
            this.plugin.removeProtection(targetProtection);
        }
    }

    @EventHandler
    public void onBlockReceiveGameEvent(BlockReceiveGameEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Material material = e.getBlock().getType();
        if (!Material.SCULK_SENSOR.equals((Object)material) && !Material.CALIBRATED_SCULK_SENSOR.equals((Object)material)) {
            return;
        }
        Protection protection = this.plugin.findProtection(e.getBlock());
        if (protection == null) {
            return;
        }
        if (!this.plugin.canAccess(protection, player, "interact")) {
            e.setCancelled(true);
        }
    }
}

