/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.stream.Stream;

public final class Translator {
    private static final String TRANSLATION_FILE_FORMAT = "lang/%s.properties";
    private static final Properties fallback = Translator.loadTranslation("en");
    private static Properties translation = Translator.loadTranslation("en");
    private static String selected = "en";
    private static boolean perPlayerLocale = true;
    private static final Map<Locale, Properties> languages = new HashMap<Locale, Properties>();

    private Translator() {
    }

    public static boolean isTranslatable(String key, Locale locale) {
        if (!perPlayerLocale) {
            return translation.containsKey(key) || fallback.containsKey(key);
        }
        return Translator.tryGetProperty(key, locale) != null || Translator.tryGetProperty(key, Locale.of(locale.getLanguage())) != null || translation.containsKey(key) || fallback.containsKey(key);
    }

    public static boolean isTranslated(String key, Locale locale) {
        if (!perPlayerLocale) {
            return translation.containsKey(key);
        }
        return Translator.tryGetProperty(key, locale) != null || Translator.tryGetProperty(key, Locale.of(locale.getLanguage())) != null || translation.containsKey(key);
    }

    public static String translate(String key, Locale locale) {
        if (!perPlayerLocale) {
            return Objects.requireNonNullElseGet(translation.getProperty(key), () -> Objects.requireNonNullElse(fallback.getProperty(key), key));
        }
        return Objects.requireNonNullElseGet(Translator.tryGetProperty(key, locale), () -> Objects.requireNonNullElseGet(Translator.tryGetProperty(key, Locale.of(locale.getLanguage())), () -> Objects.requireNonNullElseGet(translation.getProperty(key), () -> Objects.requireNonNullElse(fallback.getProperty(key), key))));
    }

    private static String tryGetProperty(String key, Locale locale) {
        Properties properties = languages.get(locale);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(key);
    }

    public static String selected() {
        return selected;
    }

    public static void loadAllTranslations(Path directory, String preferredLanguage, boolean perPlayerLocales) {
        long startTimeNanos = System.nanoTime();
        ClassLoader classLoader = Translator.class.getClassLoader();
        try {
            URI uri = Objects.requireNonNull(classLoader.getResource("lang/")).toURI();
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                 Stream<Path> files = Files.list(fileSystem.getPath("lang/", new String[0]));){
                files.forEach(path -> {
                    if (!path.toString().toLowerCase().endsWith(".properties")) {
                        return;
                    }
                    Locale locale = Translator.parseLocale(path.getFileName().toString().split("\\.", 2)[0]);
                    Properties properties = Translator.loadTranslation(locale.toString());
                    languages.put(locale, properties);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        selected = languages.containsKey(Translator.parseLocale(preferredLanguage)) ? preferredLanguage : "custom";
        try (Stream<Path> files = Files.list(directory);){
            files.forEach(path -> {
                if (!path.toString().toLowerCase().endsWith(".properties")) {
                    return;
                }
                Locale locale = Translator.parseLocale(path.getFileName().toString().split("\\.", 2)[0]);
                Properties properties = languages.getOrDefault(locale, new Properties());
                properties.putAll((Map<?, ?>)Translator.loadTranslationFromFile(path));
                languages.put(locale, properties);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        translation = languages.getOrDefault(Translator.parseLocale(preferredLanguage), fallback);
        perPlayerLocale = perPlayerLocales;
        long timeNanos = System.nanoTime() - startTimeNanos;
        double timeMillis = (double)timeNanos / 1000000.0;
        LogManager.getLogManager().getLogger("").info(() -> "Loaded %d localization files in %.3f ms".formatted(languages.size(), timeMillis));
    }

    private static Properties loadTranslation(String language) {
        ClassLoader classLoader = Translator.class.getClassLoader();
        Properties properties = new Properties();
        String translationFile = TRANSLATION_FILE_FORMAT.formatted(language);
        try (InputStream input = Objects.requireNonNullElseGet(classLoader.getResourceAsStream(translationFile), InputStream::nullInputStream);
             BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            properties.load(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    private static Properties loadTranslationFromFile(Path path) {
        Properties properties = new Properties();
        if (!Files.exists(path, new LinkOption[0])) {
            return properties;
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static Locale parseLocale(String string) {
        String[] segments = string.split("_", 3);
        return switch (segments.length) {
            case 1 -> Locale.of(string);
            case 2 -> Locale.of(segments[0], segments[1]);
            case 3 -> Locale.of(segments[0], segments[1], segments[2]);
            default -> Locale.ROOT;
        };
    }
}

