/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data.migration.lwc;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.AccessList;
import org.popcraft.bolt.data.MemoryStore;
import org.popcraft.bolt.data.migration.lwc.Trust;
import org.popcraft.bolt.source.Source;

public class TrustMigration {
    private static final String DEFAULT_ACCESS_NORMAL = "normal";
    private final BoltPlugin plugin;

    public TrustMigration(BoltPlugin plugin) {
        this.plugin = plugin;
    }

    public void convert() {
        if (!this.plugin.getBolt().getStore().loadAccessLists().join().isEmpty()) {
            return;
        }
        Path lwcTrustDirectory = this.plugin.getPluginsPath().resolve("LWCTrust");
        if (!Files.exists(lwcTrustDirectory, new LinkOption[0])) {
            return;
        }
        Path trustsDirectory = lwcTrustDirectory.resolve("trusts");
        if (!Files.exists(trustsDirectory, new LinkOption[0])) {
            return;
        }
        MemoryStore store = new MemoryStore();
        Gson gson = new Gson();
        try (Stream<Path> trustFiles = Files.walk(trustsDirectory, new FileVisitOption[0]);){
            trustFiles.filter(file -> !Files.isDirectory(file, new LinkOption[0])).forEach(trustFile -> {
                try {
                    String contents = Files.readString(trustFile);
                    Trust trust = (Trust)gson.fromJson(contents, Trust.class);
                    UUID owner = trust.getOwner();
                    List<UUID> trusted = trust.getTrusted();
                    HashMap<String, String> access = new HashMap<String, String>();
                    for (UUID uuid : trusted) {
                        access.put(Source.player(uuid).toString(), DEFAULT_ACCESS_NORMAL);
                    }
                    AccessList accessList = new AccessList(owner, access);
                    store.saveAccessList(accessList);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (AccessList accessList : store.loadAccessLists().join()) {
            this.plugin.getBolt().getStore().saveAccessList(accessList);
        }
    }
}

