/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data.migration.lwc;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.AccessRegistry;
import org.popcraft.bolt.access.DefaultAccess;
import org.popcraft.bolt.data.MemoryStore;
import org.popcraft.bolt.data.SQLStore;
import org.popcraft.bolt.data.migration.lwc.Block;
import org.popcraft.bolt.data.migration.lwc.Data;
import org.popcraft.bolt.data.migration.lwc.DataFlag;
import org.popcraft.bolt.data.migration.lwc.DataRights;
import org.popcraft.bolt.data.migration.lwc.EntityBlock;
import org.popcraft.bolt.data.migration.lwc.Permission;
import org.popcraft.bolt.data.migration.lwc.Protection;
import org.popcraft.bolt.data.migration.lwc.ProtectionFlag;
import org.popcraft.bolt.data.migration.lwc.ProtectionType;
import org.popcraft.bolt.data.sql.Statements;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.CompoundTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.IntArrayTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.ListTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.StringTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.util.RegionFile;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.util.BlockLocation;
import org.popcraft.bolt.util.Profiles;

public class LWCMigration {
    private static final Block BLOCK_AIR = new Block(-1, "AIR");
    private static final Map<String, EntityType> ENTITY_TYPE_KEYS = Arrays.stream(EntityType.values()).filter(entityType -> !EntityType.UNKNOWN.equals(entityType)).collect(Collectors.toMap(entityType -> entityType.getKey().toString(), entityType -> entityType));
    private final BoltPlugin plugin;
    private final Map<Integer, BlockProtection> entityBlocks = new ConcurrentHashMap<Integer, BlockProtection>();
    private final String defaultProtectionPrivate;
    private final String defaultProtectionDisplay;
    private final String defaultProtectionDeposit;
    private final String defaultProtectionWithdrawal;
    private final String defaultProtectionPublic;
    private final String defaultAccessNormal;
    private final String defaultAccessAdmin;

    public LWCMigration(BoltPlugin plugin) {
        this.plugin = plugin;
        AccessRegistry accessRegistry = plugin.getBolt().getAccessRegistry();
        this.defaultProtectionPrivate = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.PRIVATE).orElse("private");
        this.defaultProtectionDisplay = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.DISPLAY).orElse("display");
        this.defaultProtectionDeposit = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.DEPOSIT).orElse("deposit");
        this.defaultProtectionWithdrawal = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.WITHDRAWAL).orElse("withdrawal");
        this.defaultProtectionPublic = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.PUBLIC).orElse("public");
        this.defaultAccessNormal = accessRegistry.findAccessTypeWithExactPermissions(DefaultAccess.NORMAL).orElse("normal");
        this.defaultAccessAdmin = accessRegistry.findAccessTypeWithExactPermissions(DefaultAccess.ADMIN).orElse("admin");
    }

    public CompletableFuture<MemoryStore> convertAsync() {
        return CompletableFuture.supplyAsync(this::convert);
    }

    private MemoryStore convert() {
        MemoryStore store = new MemoryStore();
        HashMap<Integer, Block> blocks = new HashMap<Integer, Block>();
        ArrayList<Protection> protections = new ArrayList<Protection>();
        YamlConfiguration lwcCoreConfig = YamlConfiguration.loadConfiguration((File)this.plugin.getPluginsPath().resolve("LWC/core.yml").toFile());
        SQLStore.Configuration configuration = new SQLStore.Configuration(lwcCoreConfig.getString("database.adapter", "sqlite").toLowerCase(), lwcCoreConfig.getString("database.path", "%s/LWC/lwc.db".formatted(this.plugin.getPluginsPath().toFile().getName())), lwcCoreConfig.getString("database.host", ""), lwcCoreConfig.getString("database.database", ""), lwcCoreConfig.getString("database.username", ""), lwcCoreConfig.getString("database.password", ""), lwcCoreConfig.getString("database.prefix", "lwc_"), Map.of("useSSL", lwcCoreConfig.getString("database.useSSL", "false")));
        String connectionUrl = "mysql".equals(configuration.type()) ? "jdbc:mysql://%s/%s".formatted(configuration.hostname(), configuration.database()) : "jdbc:sqlite:%s".formatted(configuration.path());
        try (Connection connection = DriverManager.getConnection(connectionUrl, configuration.username(), configuration.password());
             Statement statement = connection.createStatement();){
            ResultSet blockSet = statement.executeQuery(Statements.LWC_SELECT_ALL_BLOCK_IDS.get(configuration.type()).formatted(configuration.prefix()));
            while (blockSet.next()) {
                int id = blockSet.getInt("id");
                String name = blockSet.getString("name");
                blocks.put(id, new Block(id, name));
            }
            ResultSet protectionSet = statement.executeQuery(Statements.LWC_SELECT_ALL_PROTECTIONS.get(configuration.type()).formatted(configuration.prefix()));
            while (protectionSet.next()) {
                Date date;
                try {
                    date = protectionSet.getDate("date");
                }
                catch (SQLDataException e) {
                    date = new Date(protectionSet.getInt("date"));
                }
                protections.add(new Protection(protectionSet.getInt("id"), protectionSet.getString("owner"), protectionSet.getInt("type"), protectionSet.getInt("x"), protectionSet.getInt("y"), protectionSet.getInt("z"), protectionSet.getString("data"), protectionSet.getInt("blockId"), protectionSet.getString("world"), protectionSet.getString("password"), date, protectionSet.getLong("last_accessed")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return store;
        }
        Gson gson = new Gson();
        for (Protection protection : protections) {
            Source passwordSource;
            boolean exists;
            BlockLocation blockLocation = new BlockLocation(protection.world(), protection.x(), protection.y(), protection.z());
            boolean bl = exists = this.plugin.getBolt().getStore().loadBlockProtection(blockLocation).join() != null;
            if (exists) continue;
            String protectionType = this.getProtectionType(protection);
            HashMap<String, String> access = new HashMap<String, String>();
            Data data = (Data)gson.fromJson(protection.data(), Data.class);
            if (data != null) {
                List<DataRights> dataRights;
                List<DataFlag> dataFlags = data.getFlags();
                if (dataFlags != null) {
                    for (DataFlag flag : dataFlags) {
                        if (flag.getId() == ProtectionFlag.REDSTONE.ordinal()) {
                            access.put(Source.of("redstone").toString(), this.defaultAccessAdmin);
                            continue;
                        }
                        if (flag.getId() == ProtectionFlag.HOPPER.ordinal()) {
                            access.put(Source.of("block").toString(), this.defaultAccessAdmin);
                            continue;
                        }
                        if (flag.getId() != ProtectionFlag.AUTOCLOSE.ordinal()) continue;
                        access.put(Source.of("door").toString(), "autoclose");
                    }
                }
                if ((dataRights = data.getRights()) != null) {
                    for (DataRights rights : data.getRights()) {
                        String sourceIdentifier;
                        String sourceType;
                        String accessType = rights.getRights() == Permission.Access.ADMIN.ordinal() ? this.defaultAccessAdmin : this.defaultAccessNormal;
                        String identifier = rights.getName();
                        if (rights.getType() == Permission.Type.GROUP.ordinal()) {
                            sourceType = "permission";
                            identifier = "group.%s".formatted(identifier);
                        } else {
                            sourceType = rights.getType() == Permission.Type.PLAYER.ordinal() ? "player" : (rights.getType() == Permission.Type.TOWN.ordinal() ? "town" : (rights.getType() == Permission.Type.REGION.ordinal() ? "region" : (rights.getType() == Permission.Type.FACTION.ordinal() ? "faction" : null)));
                        }
                        if (sourceType == null || (sourceIdentifier = this.plugin.getSourceTransformer(sourceType).transformIdentifier(identifier).join()) == null) continue;
                        access.put(Source.of(sourceType, sourceIdentifier).toString(), accessType);
                    }
                }
            }
            if (protection.password() != null && !protection.password().isEmpty() && (passwordSource = Source.password(protection.password())) != null) {
                access.put(passwordSource.toString(), this.defaultAccessNormal);
            }
            UUID ownerUuid = Optional.ofNullable(Profiles.findProfileByName(protection.owner()).uuid()).orElseGet(() -> Profiles.lookupProfileByName(protection.owner()).join().uuid());
            BlockProtection blockProtection = new BlockProtection(UUID.randomUUID(), Objects.requireNonNullElse(ownerUuid, Profiles.NIL_UUID), protectionType, protection.date().getTime(), TimeUnit.MILLISECONDS.convert(protection.lastAccessed(), TimeUnit.SECONDS), access, protection.world(), protection.x(), protection.y(), protection.z(), blocks.getOrDefault(protection.blockId(), BLOCK_AIR).name());
            if (EntityBlock.check(blockProtection)) {
                this.entityBlocks.put(blockProtection.getX(), blockProtection);
                continue;
            }
            store.saveBlockProtection(blockProtection);
        }
        return store;
    }

    private String getProtectionType(Protection protection) {
        String protectionType = protection.type() == ProtectionType.PUBLIC.ordinal() ? this.defaultProtectionPublic : (protection.type() == ProtectionType.DONATION.ordinal() ? this.defaultProtectionDeposit : (protection.type() == ProtectionType.DISPLAY.ordinal() ? this.defaultProtectionDisplay : (protection.type() == ProtectionType.SUPPLY.ordinal() ? this.defaultProtectionWithdrawal : this.defaultProtectionPrivate)));
        return protectionType;
    }

    public boolean hasEntityBlocks() {
        return !this.entityBlocks.isEmpty();
    }

    public CompletableFuture<MemoryStore> convertEntityBlocks() {
        return CompletableFuture.supplyAsync(() -> {
            MemoryStore store = new MemoryStore();
            Bukkit.getServer().getWorlds().forEach(world -> {
                Optional<Path> entityDirectory = this.findEntitiesDirectory((World)world);
                if (entityDirectory.isPresent()) {
                    try (Stream<Path> regionWalker = Files.walk(entityDirectory.get(), new FileVisitOption[0]);){
                        regionWalker.filter(path -> {
                            String fileName = path.getFileName().toString();
                            return fileName.startsWith("r.") && fileName.endsWith(".mca");
                        }).forEach(region -> {
                            RegionFile regionFile = new RegionFile(region.toFile());
                            ArrayList entities = new ArrayList();
                            regionFile.getChunks().forEach(chunk -> chunk.getData().getList("Entities").map(ListTag::value).stream().flatMap(Collection::stream).filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).forEach(entities::add));
                            for (CompoundTag entity : entities) {
                                int magic;
                                BlockProtection blockProtection;
                                UUID uuid = entity.getIntArray("UUID").map(IntArrayTag::value).filter(array -> ((int[])array).length == 4).map(array -> {
                                    long mostSigBitsHigh = (long)array[0] & 0xFFFFFFFFL;
                                    long mostSigBitsLow = (long)array[1] & 0xFFFFFFFFL;
                                    long mostSigBits = mostSigBitsHigh << 32 | mostSigBitsLow;
                                    long leastSigBitsHigh = (long)array[2] & 0xFFFFFFFFL;
                                    long leastSigBitsLow = (long)array[3] & 0xFFFFFFFFL;
                                    long leastSigBits = leastSigBitsHigh << 32 | leastSigBitsLow;
                                    return new UUID(mostSigBits, leastSigBits);
                                }).orElse(null);
                                if (uuid == null || (blockProtection = this.entityBlocks.get(magic = EntityBlock.magic(uuid))) == null) continue;
                                EntityType entityType = entity.getString("id").map(StringTag::value).map(ENTITY_TYPE_KEYS::get).orElse(EntityType.UNKNOWN);
                                EntityProtection entityProtection = new EntityProtection(uuid, blockProtection.getOwner(), blockProtection.getType(), blockProtection.getCreated(), blockProtection.getAccessed(), blockProtection.getAccess(), entityType.name());
                                store.saveEntityProtection(entityProtection);
                            }
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            return store;
        });
    }

    private Optional<Path> findEntitiesDirectory(World world) {
        Optional<Path> optional;
        block8: {
            Stream<Path> paths = Files.walk(world.getWorldFolder().toPath(), new FileVisitOption[0]);
            try {
                optional = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> "entities".equals(path.getFileName().toString())).findFirst();
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            paths.close();
        }
        return optional;
    }
}

