/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data.migration.lwc;

import java.io.File;
import java.util.EnumMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.AccessRegistry;
import org.popcraft.bolt.access.DefaultAccess;

public class ConfigMigration {
    private final BoltPlugin plugin;
    private final String defaultProtectionPrivate;
    private final String defaultProtectionDisplay;
    private final String defaultProtectionDeposit;
    private final String defaultProtectionWithdrawal;
    private final String defaultProtectionPublic;

    public ConfigMigration(BoltPlugin plugin) {
        this.plugin = plugin;
        AccessRegistry accessRegistry = plugin.getBolt().getAccessRegistry();
        this.defaultProtectionPrivate = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.PRIVATE).orElse("private");
        this.defaultProtectionDisplay = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.DISPLAY).orElse("display");
        this.defaultProtectionDeposit = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.DEPOSIT).orElse("deposit");
        this.defaultProtectionWithdrawal = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.WITHDRAWAL).orElse("withdrawal");
        this.defaultProtectionPublic = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.PUBLIC).orElse("public");
    }

    public void convert() {
        if (!this.plugin.loadProtections().isEmpty()) {
            return;
        }
        this.convertCore();
        this.convertDoors();
    }

    private void convertCore() {
        YamlConfiguration lwcCoreConfig = YamlConfiguration.loadConfiguration((File)this.plugin.getPluginsPath().resolve("LWC/core.yml").toFile());
        ConfigurationSection blocks = lwcCoreConfig.getConfigurationSection("protections.blocks");
        if (blocks == null) {
            return;
        }
        EnumMap<Material, String> migrateToBoltConfig = new EnumMap<Material, String>(Material.class);
        for (String block : blocks.getKeys(false)) {
            boolean enabled = blocks.getBoolean("%s.enabled".formatted(block), false);
            Material material2 = Material.getMaterial((String)block.toUpperCase());
            if (material2 == null || !material2.isBlock()) continue;
            migrateToBoltConfig.put(material2, enabled ? blocks.getString("%s.autoRegister".formatted(block), "false") : "false");
        }
        if (!migrateToBoltConfig.isEmpty()) {
            migrateToBoltConfig.forEach((material, protectionType) -> {
                String boltProtectionType = "private".equals(protectionType) ? this.defaultProtectionPrivate : ("display".equals(protectionType) ? this.defaultProtectionDisplay : ("donation".equals(protectionType) ? this.defaultProtectionDeposit : ("supply".equals(protectionType) ? this.defaultProtectionWithdrawal : ("public".equals(protectionType) ? this.defaultProtectionPublic : protectionType))));
                if (this.plugin.getMaterialTags().containsKey(material)) {
                    this.plugin.getConfig().set("blocks.#%s.autoProtect".formatted(this.plugin.getMaterialTags().get(material).getKey().getKey()), (Object)boltProtectionType);
                } else {
                    this.plugin.getConfig().set("blocks.%s.autoProtect".formatted(material.name().toLowerCase()), (Object)boltProtectionType);
                }
            });
            this.plugin.saveConfig();
            this.plugin.reload();
        }
    }

    private void convertDoors() {
        YamlConfiguration lwcDoorsConfig = YamlConfiguration.loadConfiguration((File)this.plugin.getPluginsPath().resolve("LWC/doors.yml").toFile());
        ConfigurationSection doors = lwcDoorsConfig.getConfigurationSection("doors");
        if (doors == null) {
            return;
        }
        boolean enabled = doors.getBoolean("enabled", false);
        boolean doubleDoors = doors.getBoolean("doubleDoors", false);
        String action = doors.getString("action", "toggle");
        int interval = doors.getInt("interval", 3);
        boolean isOpenAndClose = "openAndClose".equals(action);
        if (!(enabled || doubleDoors || isOpenAndClose)) {
            return;
        }
        this.plugin.getConfig().set("doors.open-iron", (Object)enabled);
        this.plugin.getConfig().set("doors.open-double", (Object)doubleDoors);
        this.plugin.getConfig().set("doors.close-after", (Object)interval);
        this.plugin.getConfig().set("access.autoclose.require-permission", (Object)true);
        this.plugin.getConfig().set("access.autoclose.allows", List.of("auto_close"));
        this.plugin.getConfig().set("sources.door.require-permission", (Object)true);
        this.plugin.getConfig().set("sources.door.unique", (Object)true);
        this.plugin.saveConfig();
        this.plugin.reload();
    }
}

