/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data.migration.lwc;

import com.google.gson.Gson;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.AccessRegistry;
import org.popcraft.bolt.access.DefaultAccess;
import org.popcraft.bolt.data.SQLStore;
import org.popcraft.bolt.data.migration.lwc.Data;
import org.popcraft.bolt.data.migration.lwc.DataFlag;
import org.popcraft.bolt.data.migration.lwc.DataRights;
import org.popcraft.bolt.data.migration.lwc.Permission;
import org.popcraft.bolt.data.migration.lwc.ProtectionFlag;
import org.popcraft.bolt.data.migration.lwc.ProtectionType;
import org.popcraft.bolt.data.sql.Statements;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.util.BlockLocation;

public class BoltMigration {
    private final BoltPlugin plugin;
    private final String defaultProtectionDisplay;
    private final String defaultProtectionDeposit;
    private final String defaultProtectionWithdrawal;
    private final String defaultProtectionPublic;

    public BoltMigration(BoltPlugin plugin) {
        this.plugin = plugin;
        AccessRegistry accessRegistry = plugin.getBolt().getAccessRegistry();
        this.defaultProtectionDisplay = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.DISPLAY).orElse("display");
        this.defaultProtectionDeposit = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.DEPOSIT).orElse("deposit");
        this.defaultProtectionWithdrawal = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.WITHDRAWAL).orElse("withdrawal");
        this.defaultProtectionPublic = accessRegistry.findProtectionTypeWithExactPermissions(DefaultAccess.PUBLIC).orElse("public");
    }

    public CompletableFuture<Void> convertAsync() {
        return CompletableFuture.runAsync(this::convert);
    }

    private void convert() {
        HashMap<String, Integer> blockIds = new HashMap<String, Integer>();
        AtomicInteger blockId = new AtomicInteger();
        HashSet<BlockLocation> existing = new HashSet<BlockLocation>();
        YamlConfiguration lwcCoreConfig = YamlConfiguration.loadConfiguration((File)this.plugin.getPluginsPath().resolve("LWC/core.yml").toFile());
        SQLStore.Configuration configuration = new SQLStore.Configuration(lwcCoreConfig.getString("database.adapter", "sqlite").toLowerCase(), lwcCoreConfig.getString("database.path", "%s/LWC/lwc.db".formatted(this.plugin.getPluginsPath().toFile().getName())), lwcCoreConfig.getString("database.host", ""), lwcCoreConfig.getString("database.database", ""), lwcCoreConfig.getString("database.username", ""), lwcCoreConfig.getString("database.password", ""), lwcCoreConfig.getString("database.prefix", "lwc_"), Map.of("useSSL", lwcCoreConfig.getString("database.useSSL", "false")));
        String connectionUrl = "mysql".equals(configuration.type()) ? "jdbc:mysql://%s/%s".formatted(configuration.hostname(), configuration.database()) : "jdbc:sqlite:%s".formatted(configuration.path());
        try (Connection connection = DriverManager.getConnection(connectionUrl, configuration.username(), configuration.password());
             Statement statement = connection.createStatement();
             PreparedStatement addBlock = connection.prepareStatement(Statements.LWC_INSERT_BLOCK_ID.get(configuration.type()).formatted(configuration.prefix()));
             PreparedStatement addProtection = connection.prepareStatement(Statements.LWC_INSERT_OR_IGNORE_PROTECTION.get(configuration.type()).formatted(configuration.prefix()));){
            ResultSet blockSet = statement.executeQuery(Statements.LWC_SELECT_ALL_BLOCK_IDS.get(configuration.type()).formatted(configuration.prefix()));
            while (blockSet.next()) {
                int id = blockSet.getInt("id");
                String name = blockSet.getString("name");
                blockIds.put(name, id);
                if (id <= blockId.get()) continue;
                blockId.set(id);
            }
            ResultSet existingSet = statement.executeQuery(Statements.LWC_SELECT_ALL_PROTECTIONS.get(configuration.type()).formatted(configuration.prefix()));
            while (existingSet.next()) {
                existing.add(new BlockLocation(existingSet.getString("world"), existingSet.getInt("x"), existingSet.getInt("y"), existingSet.getInt("z")));
            }
            Gson gson = new Gson();
            connection.setAutoCommit(false);
            for (BlockProtection blockProtection : this.plugin.getBolt().getStore().loadBlockProtections().join()) {
                String protectionBlock = blockProtection.getBlock();
                if (existing.contains(BlockLocation.fromProtection(blockProtection))) continue;
                if (!blockIds.containsKey(protectionBlock)) {
                    int nextId = blockId.incrementAndGet();
                    blockIds.put(protectionBlock, nextId);
                    addBlock.setInt(1, nextId);
                    addBlock.setString(2, protectionBlock);
                    addBlock.execute();
                }
                addProtection.setString(1, blockProtection.getOwner().toString());
                addProtection.setInt(2, this.convertProtectionType(blockProtection));
                addProtection.setInt(3, blockProtection.getX());
                addProtection.setInt(4, blockProtection.getY());
                addProtection.setInt(5, blockProtection.getZ());
                addProtection.setString(6, gson.toJson((Object)this.convertData(blockProtection)));
                addProtection.setInt(7, (Integer)blockIds.get(protectionBlock));
                addProtection.setString(8, blockProtection.getWorld());
                addProtection.setString(9, this.convertPassword(blockProtection));
                addProtection.setString(10, new Timestamp(blockProtection.getCreated()).toString());
                addProtection.setLong(11, TimeUnit.SECONDS.convert(blockProtection.getAccessed(), TimeUnit.MILLISECONDS));
                addProtection.setString(12, null);
                addProtection.execute();
            }
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private int convertProtectionType(BlockProtection blockProtection) {
        if (this.defaultProtectionPublic.equals(blockProtection.getType())) {
            return ProtectionType.PUBLIC.ordinal();
        }
        if (this.defaultProtectionDeposit.equals(blockProtection.getType())) {
            return ProtectionType.DONATION.ordinal();
        }
        if (this.defaultProtectionDisplay.equals(blockProtection.getType())) {
            return ProtectionType.DISPLAY.ordinal();
        }
        if (this.defaultProtectionWithdrawal.equals(blockProtection.getType())) {
            return ProtectionType.SUPPLY.ordinal();
        }
        boolean password = blockProtection.getAccess().entrySet().stream().anyMatch(entry -> "password".equals(Source.parse((String)entry.getKey()).getType()));
        if (password) {
            return ProtectionType.PASSWORD.ordinal();
        }
        return ProtectionType.PRIVATE.ordinal();
    }

    private Data convertData(BlockProtection blockProtection) {
        Data data = new Data();
        ArrayList<DataFlag> flags = new ArrayList<DataFlag>();
        ArrayList<DataRights> rights = new ArrayList<DataRights>();
        if (blockProtection.getAccess().isEmpty()) {
            data.setFlags(flags);
            data.setRights(rights);
            return data;
        }
        for (Map.Entry<String, String> entry : blockProtection.getAccess().entrySet()) {
            Permission.Access permissionAccess;
            Source source = Source.parse(entry.getKey());
            String access = entry.getValue();
            if ("block".equals(source.getType())) {
                dataFlag = new DataFlag();
                dataFlag.setId(ProtectionFlag.HOPPER.ordinal());
                flags.add(dataFlag);
            } else if ("door".equals(source.getType())) {
                dataFlag = new DataFlag();
                dataFlag.setId(ProtectionFlag.AUTOCLOSE.ordinal());
                flags.add(dataFlag);
            }
            switch (access) {
                case "normal": {
                    Permission.Access access2 = Permission.Access.PLAYER;
                    break;
                }
                case "admin": {
                    Permission.Access access2 = Permission.Access.ADMIN;
                    break;
                }
                default: {
                    Permission.Access access2 = permissionAccess = null;
                }
            }
            if ("permission".equals(source.getType()) && !source.getIdentifier().startsWith("group.")) continue;
            Permission.Type permissionType = switch (source.getType()) {
                case "permission" -> Permission.Type.GROUP;
                case "player" -> Permission.Type.PLAYER;
                case "town" -> Permission.Type.TOWN;
                case "region" -> Permission.Type.REGION;
                case "faction" -> Permission.Type.FACTION;
                default -> null;
            };
            String name = "permission".equals(source.getType()) ? source.getIdentifier().substring(source.getIdentifier().indexOf(46) + 1) : source.getIdentifier();
            if (permissionAccess == null || permissionType == null) continue;
            DataRights dataRights = new DataRights();
            dataRights.setRights(permissionAccess.ordinal());
            dataRights.setType(permissionType.ordinal());
            dataRights.setName(name);
            rights.add(dataRights);
        }
        data.setFlags(flags);
        data.setRights(rights);
        return data;
    }

    private String convertPassword(BlockProtection blockProtection) {
        if (blockProtection.getAccess().isEmpty()) {
            return "";
        }
        return blockProtection.getAccess().keySet().stream().map(Source::parse).filter(source -> "password".equals(source.getType())).map(Source::getIdentifier).findFirst().orElse("");
    }
}

