/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data.migration.lockette;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.data.MemoryStore;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.ByteTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.CompoundTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.IntTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.ListTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.LongArrayTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.StringTag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.Tag;
import org.popcraft.bolt.lib.org.popcraft.chunky.nbt.util.RegionFile;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.util.BlockLocation;
import org.popcraft.bolt.util.ChunkPos;
import org.popcraft.bolt.util.Profiles;

public class LocketteMigration {
    private final BoltPlugin plugin;

    public LocketteMigration(BoltPlugin plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<MemoryStore> convertAsync() {
        return CompletableFuture.supplyAsync(this::convert);
    }

    private MemoryStore convert() {
        MemoryStore store = new MemoryStore();
        Bukkit.getServer().getWorlds().forEach(world -> {
            Optional<Path> regionDirectory = this.findRegionDirectory((World)world);
            if (regionDirectory.isPresent()) {
                ArrayList locketteProtections = new ArrayList();
                try (Stream<Path> regionWalker = Files.walk(regionDirectory.get(), new FileVisitOption[0]);){
                    regionWalker.filter(path -> {
                        String fileName = path.getFileName().toString();
                        return fileName.startsWith("r.") && fileName.endsWith(".mca");
                    }).forEach(region -> {
                        RegionFile regionFile = new RegionFile(region.toFile());
                        regionFile.getChunks().forEach(chunk -> chunk.getData().getList("block_entities").map(ListTag::value).ifPresent(blockEntityTags -> {
                            for (Tag tag : blockEntityTags) {
                                CompoundTag blockEntityCompound;
                                String id;
                                if (!(tag instanceof CompoundTag) || !"minecraft:sign".equals(id = (String)(blockEntityCompound = (CompoundTag)tag).getString("id").map(StringTag::value).orElse(null))) continue;
                                LocketteProtection pdcProtection = this.fromPersistentData(blockEntityCompound);
                                if (pdcProtection != null) {
                                    locketteProtections.add(pdcProtection);
                                    continue;
                                }
                                LocketteProtection messagesProtection = this.fromSignMessages(blockEntityCompound);
                                if (messagesProtection == null) continue;
                                locketteProtections.add(messagesProtection);
                            }
                        }));
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int permits = 10;
                Semaphore working = new Semaphore(10);
                for (LocketteProtection locketteProtection : locketteProtections) {
                    int chunkX = locketteProtection.x() >> 4;
                    int chunkZ = locketteProtection.z() >> 4;
                    ChunkPos chunkPos = new ChunkPos(world.getName(), chunkX, chunkZ);
                    try {
                        working.acquire();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    ((CompletableFuture)world.getChunkAtAsync(chunkX, chunkZ).thenAccept(ignored -> {
                        Block signBlock = world.getBlockAt(locketteProtection.x(), locketteProtection.y(), locketteProtection.z());
                        BlockData patt0$temp = signBlock.getBlockData();
                        if (patt0$temp instanceof WallSign) {
                            WallSign wallSign = (WallSign)patt0$temp;
                            BlockFace facing = wallSign.getFacing();
                            Block block = signBlock.getRelative(facing.getOppositeFace());
                            BlockLocation blockLocation = new BlockLocation(world.getName(), block.getX(), block.getY(), block.getZ());
                            BlockProtection existing = store.loadBlockProtection(blockLocation).join();
                            if (existing == null) {
                                BlockProtection protection = this.plugin.createProtection(block, locketteProtection.owner(), locketteProtection.type());
                                protection.setAccess(locketteProtection.access());
                                store.saveBlockProtection(protection);
                            } else {
                                if (Profiles.NIL_UUID.equals(existing.getOwner())) {
                                    existing.setOwner(locketteProtection.owner());
                                }
                                existing.getAccess().putAll(locketteProtection.access());
                                if ("public".equals(locketteProtection.type())) {
                                    existing.setType("public");
                                }
                                store.saveBlockProtection(existing);
                            }
                        }
                    })).thenRun(working::release);
                }
                working.acquireUninterruptibly(10);
            }
        });
        return store;
    }

    private LocketteProtection fromPersistentData(CompoundTag sign) {
        Integer x = sign.getInt("x").map(IntTag::value).orElse(null);
        Integer y = sign.getInt("y").map(IntTag::value).orElse(null);
        Integer z = sign.getInt("z").map(IntTag::value).orElse(null);
        if (x == null || y == null || z == null) {
            return null;
        }
        CompoundTag pdcCompound = sign.getCompound("PublicBukkitValues").orElse(null);
        if (pdcCompound == null) {
            return null;
        }
        String header = pdcCompound.getString("blocklocker:header").map(StringTag::value).orElse(null);
        if (header == null) {
            return null;
        }
        boolean isPublic = false;
        boolean isRedstone = false;
        UUID owner = null;
        HashMap<String, String> access = new HashMap<String, String>();
        for (int i = 0; i < 6; ++i) {
            int profileId = i + 1;
            CompoundTag profileCompound = pdcCompound.getCompound("blocklocker:profile_%d".formatted(profileId)).orElse(null);
            if (profileCompound == null) continue;
            String n = profileCompound.getString("blocklocker:n").map(StringTag::value).orElse(null);
            long[] u = profileCompound.getLongArray("blocklocker:u").map(LongArrayTag::value).orElse(null);
            Byte e = profileCompound.getByte("blocklocker:e").map(ByteTag::value).orElse(null);
            String l = profileCompound.getString("blocklocker:l").map(StringTag::value).orElse(null);
            String g = profileCompound.getString("blocklocker:g").map(StringTag::value).orElse(null);
            Byte r = profileCompound.getByte("blocklocker:r").map(ByteTag::value).orElse(null);
            Integer t = profileCompound.getInt("blocklocker:t").map(IntTag::value).orElse(null);
            if (n != null) {
                UUID uuid = u == null ? Profiles.findOrLookupProfileByName(n).join().uuid() : new UUID(u[0], u[1]);
                if (uuid == null) continue;
                if ("PRIVATE".equals(header) && owner == null) {
                    owner = uuid;
                    continue;
                }
                access.put(Source.player(uuid).toString(), "normal");
                continue;
            }
            if (e != null && e == 1) {
                isPublic = true;
                continue;
            }
            if (l != null) {
                access.put(Source.of("permission", "group.%s".formatted(l)).toString(), "normal");
                continue;
            }
            if (g != null) {
                access.put(Source.of("permission", "group.%s".formatted(g)).toString(), "normal");
                continue;
            }
            if (r != null && r == 1) {
                isRedstone = true;
                continue;
            }
            if (t == null) continue;
            access.put(Source.of("door").toString(), "autoclose");
        }
        String type = isPublic ? "public" : "private";
        return new LocketteProtection(x, y, z, Objects.requireNonNullElse(owner, Profiles.NIL_UUID), type, access);
    }

    private LocketteProtection fromSignMessages(CompoundTag sign) {
        Integer x = sign.getInt("x").map(IntTag::value).orElse(null);
        Integer y = sign.getInt("y").map(IntTag::value).orElse(null);
        Integer z = sign.getInt("z").map(IntTag::value).orElse(null);
        if (x == null || y == null || z == null) {
            return null;
        }
        ArrayList messages = new ArrayList(sign.getCompound("front_text").flatMap(compound -> compound.getList("messages")).map(ListTag::value).map(list -> {
            ArrayList<String> messageList = new ArrayList<String>();
            for (Tag tag : list) {
                StringTag message;
                if (!(tag instanceof StringTag) || (message = (StringTag)tag).value().isBlank()) continue;
                messageList.add(message.value());
            }
            return messageList;
        }).orElse(List.of()));
        messages.addAll(sign.getCompound("back_text").flatMap(compound -> compound.getList("messages")).map(ListTag::value).map(list -> {
            ArrayList<String> messageList = new ArrayList<String>();
            for (Tag tag : list) {
                StringTag message;
                if (!(tag instanceof StringTag) || (message = (StringTag)tag).value().isBlank()) continue;
                messageList.add(message.value());
            }
            return messageList;
        }).orElse(List.of()));
        boolean isValid = false;
        boolean isPublic = false;
        boolean isRedstone = false;
        boolean hasPrivateHeader = false;
        UUID owner = null;
        HashMap<String, String> access = new HashMap<String, String>();
        for (String message : messages) {
            UUID uuid;
            String cleaned = message.replaceAll("\"", "");
            boolean privateHeader = cleaned.contains("[Private]");
            boolean moreUsersHeader = cleaned.contains("[More Users]");
            if (privateHeader || moreUsersHeader) {
                isValid = true;
                hasPrivateHeader = privateHeader;
                continue;
            }
            if (cleaned.contains("[Everyone]")) {
                isPublic = true;
                continue;
            }
            if (cleaned.contains("[Redstone]")) {
                isRedstone = true;
                continue;
            }
            if (cleaned.contains("Timer")) {
                access.put(Source.of("door").toString(), "autoclose");
                continue;
            }
            boolean isLocketteProFormat = cleaned.contains("#");
            if (isLocketteProFormat) {
                int uuidStart = cleaned.indexOf("#") + 1;
                try {
                    String name = cleaned.substring(uuidStart).trim().replace(" ", "");
                    uuid = UUID.fromString(name);
                }
                catch (IllegalArgumentException ignore) {
                    uuid = null;
                }
            } else {
                String name = cleaned.trim().replace(" ", "");
                uuid = Profiles.findOrLookupProfileByName(name).join().uuid();
            }
            if (uuid == null) continue;
            if (hasPrivateHeader && owner == null) {
                owner = uuid;
                continue;
            }
            access.put(Source.player(uuid).toString(), "normal");
        }
        if (!isValid) {
            return null;
        }
        String type = isPublic ? "public" : "private";
        return new LocketteProtection(x, y, z, Objects.requireNonNullElse(owner, Profiles.NIL_UUID), type, access);
    }

    private Optional<Path> findRegionDirectory(World world) {
        Optional<Path> optional;
        block8: {
            Stream<Path> paths = Files.walk(world.getWorldFolder().toPath(), new FileVisitOption[0]);
            try {
                optional = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> "region".equals(path.getFileName().toString())).findFirst();
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            paths.close();
        }
        return optional;
    }

    private record LocketteProtection(int x, int y, int z, UUID owner, String type, Map<String, String> access) {
    }
}

