/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.popcraft.bolt.access.AccessList;
import org.popcraft.bolt.data.Store;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.util.BlockLocation;
import org.popcraft.bolt.util.Group;
import org.popcraft.bolt.util.Metrics;

public class SimpleProtectionCache
implements Store {
    private final Map<BlockLocation, UUID> cachedBlockLocationId = new ConcurrentHashMap<BlockLocation, UUID>();
    private final Map<UUID, BlockLocation> cachedBlockIdLocation = new ConcurrentHashMap<UUID, BlockLocation>();
    private final Map<UUID, BlockProtection> cachedBlocks = new ConcurrentHashMap<UUID, BlockProtection>();
    private final Map<UUID, EntityProtection> cachedEntities = new ConcurrentHashMap<UUID, EntityProtection>();
    private final Map<String, Group> cachedGroups = new ConcurrentHashMap<String, Group>();
    private final Map<UUID, AccessList> cachedAccessLists = new ConcurrentHashMap<UUID, AccessList>();
    private final Store backingStore;

    public SimpleProtectionCache(Store backingStore) {
        this.backingStore = backingStore;
        backingStore.loadBlockProtections().join().forEach(blockProtection -> {
            UUID id = blockProtection.getId();
            BlockLocation blockLocation = BlockLocation.fromProtection(blockProtection);
            this.cachedBlockLocationId.put(blockLocation, id);
            this.cachedBlockIdLocation.put(id, blockLocation);
            this.cachedBlocks.put(id, (BlockProtection)blockProtection);
        });
        backingStore.loadEntityProtections().join().forEach(entityProtection -> this.cachedEntities.putIfAbsent(entityProtection.getId(), (EntityProtection)entityProtection));
        backingStore.loadGroups().join().forEach(group -> this.cachedGroups.putIfAbsent(group.getName(), (Group)group));
        backingStore.loadAccessLists().join().forEach(accessList -> this.cachedAccessLists.putIfAbsent(accessList.getOwner(), (AccessList)accessList));
    }

    @Override
    public CompletableFuture<BlockProtection> loadBlockProtection(BlockLocation location) {
        UUID id = this.cachedBlockLocationId.get(location);
        BlockProtection blockProtection = id == null ? null : this.cachedBlocks.get(id);
        Metrics.recordProtectionAccess(blockProtection != null);
        return CompletableFuture.completedFuture(blockProtection);
    }

    @Override
    public CompletableFuture<Collection<BlockProtection>> loadBlockProtections() {
        return CompletableFuture.completedFuture(this.cachedBlocks.values());
    }

    @Override
    public void saveBlockProtection(BlockProtection protection) {
        UUID id = protection.getId();
        BlockLocation oldBlockLocation = this.cachedBlockIdLocation.remove(id);
        if (oldBlockLocation != null) {
            this.cachedBlockLocationId.remove(oldBlockLocation);
        }
        BlockLocation blockLocation = BlockLocation.fromProtection(protection);
        this.cachedBlockLocationId.put(blockLocation, id);
        this.cachedBlockIdLocation.put(id, blockLocation);
        this.cachedBlocks.put(id, protection);
        this.backingStore.saveBlockProtection(protection);
    }

    @Override
    public void removeBlockProtection(BlockProtection protection) {
        UUID id = protection.getId();
        BlockLocation blockLocation = BlockLocation.fromProtection(protection);
        this.cachedBlockLocationId.remove(blockLocation);
        this.cachedBlockIdLocation.remove(id);
        this.cachedBlocks.remove(id);
        this.backingStore.removeBlockProtection(protection);
    }

    @Override
    public CompletableFuture<EntityProtection> loadEntityProtection(UUID id) {
        EntityProtection entityProtection = this.cachedEntities.get(id);
        Metrics.recordProtectionAccess(entityProtection != null);
        return CompletableFuture.completedFuture(entityProtection);
    }

    @Override
    public CompletableFuture<Collection<EntityProtection>> loadEntityProtections() {
        return CompletableFuture.completedFuture(this.cachedEntities.values());
    }

    @Override
    public void saveEntityProtection(EntityProtection protection) {
        this.cachedEntities.put(protection.getId(), protection);
        this.backingStore.saveEntityProtection(protection);
    }

    @Override
    public void removeEntityProtection(EntityProtection protection) {
        this.cachedEntities.remove(protection.getId());
        this.backingStore.removeEntityProtection(protection);
    }

    @Override
    public CompletableFuture<Group> loadGroup(String group) {
        return CompletableFuture.completedFuture(this.cachedGroups.get(group));
    }

    @Override
    public CompletableFuture<Collection<Group>> loadGroups() {
        return CompletableFuture.completedFuture(this.cachedGroups.values());
    }

    @Override
    public void saveGroup(Group group) {
        this.cachedGroups.put(group.getName(), group);
        this.backingStore.saveGroup(group);
    }

    @Override
    public void removeGroup(Group group) {
        this.cachedGroups.remove(group.getName());
        this.backingStore.removeGroup(group);
    }

    @Override
    public CompletableFuture<AccessList> loadAccessList(UUID owner) {
        return CompletableFuture.completedFuture(this.cachedAccessLists.get(owner));
    }

    @Override
    public CompletableFuture<Collection<AccessList>> loadAccessLists() {
        return CompletableFuture.completedFuture(this.cachedAccessLists.values());
    }

    @Override
    public void saveAccessList(AccessList accessList) {
        this.cachedAccessLists.put(accessList.getOwner(), accessList);
        this.backingStore.saveAccessList(accessList);
    }

    @Override
    public void removeAccessList(AccessList accessList) {
        this.cachedAccessLists.remove(accessList.getOwner());
        this.backingStore.removeAccessList(accessList);
    }

    @Override
    public long pendingSave() {
        return this.backingStore.pendingSave();
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.backingStore.flush();
    }
}

