/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.popcraft.bolt.data.Profile;
import org.popcraft.bolt.data.ProfileCache;

public class SimpleProfileCache
implements ProfileCache {
    public static final Profile EMPTY_PROFILE = new Profile(null, null);
    private final Path path;
    private final Map<UUID, String> uuidName = new ConcurrentHashMap<UUID, String>();
    private final Map<String, UUID> nameUuid = new ConcurrentHashMap<String, UUID>();
    private final Map<String, UUID> lowercaseNameUuid = new ConcurrentHashMap<String, UUID>();

    public SimpleProfileCache(Path path) {
        this.path = path;
    }

    @Override
    public void load() {
        if (this.path == null || Files.notExists(this.path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            reader.lines().forEach(line -> {
                String[] split = line.split(":");
                UUID uuid = UUID.fromString(split[0]);
                String name = split[1];
                this.uuidName.put(uuid, name);
                this.nameUuid.put(name, uuid);
                this.lowercaseNameUuid.put(name.toLowerCase(), uuid);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void add(UUID uuid, String name) {
        UUID existingUUID = this.nameUuid.get(name);
        String existingName = this.uuidName.get(uuid);
        if (uuid.equals(existingUUID) && name.equals(existingName)) {
            return;
        }
        this.uuidName.put(uuid, name);
        this.nameUuid.put(name, uuid);
        this.lowercaseNameUuid.put(name.toLowerCase(), uuid);
        CompletableFuture.runAsync(() -> this.save(uuid, name));
    }

    private synchronized void save(UUID uuid, String name) {
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            writer.write(String.valueOf(uuid) + ":" + name + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Profile getProfile(UUID uuid) {
        if (uuid == null) {
            return EMPTY_PROFILE;
        }
        return new Profile(uuid, this.uuidName.get(uuid));
    }

    @Override
    public Profile getProfile(String name) {
        if (name == null) {
            return EMPTY_PROFILE;
        }
        return new Profile(this.lowercaseNameUuid.get(name.toLowerCase()), name);
    }
}

