/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.data;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.popcraft.bolt.access.AccessList;
import org.popcraft.bolt.data.Store;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.util.BlockLocation;
import org.popcraft.bolt.util.Group;

public class MemoryStore
implements Store {
    private final Map<BlockLocation, BlockProtection> blockProtectionMap = new ConcurrentHashMap<BlockLocation, BlockProtection>();
    private final Map<UUID, EntityProtection> entityProtectionMap = new ConcurrentHashMap<UUID, EntityProtection>();
    private final Map<String, Group> groupMap = new ConcurrentHashMap<String, Group>();
    private final Map<UUID, AccessList> accessListMap = new ConcurrentHashMap<UUID, AccessList>();

    @Override
    public CompletableFuture<BlockProtection> loadBlockProtection(BlockLocation location) {
        return CompletableFuture.completedFuture(this.blockProtectionMap.get(location));
    }

    @Override
    public CompletableFuture<Collection<BlockProtection>> loadBlockProtections() {
        return CompletableFuture.completedFuture(List.copyOf(this.blockProtectionMap.values()));
    }

    @Override
    public void saveBlockProtection(BlockProtection protection) {
        BlockLocation blockLocation = new BlockLocation(protection.getWorld(), protection.getX(), protection.getY(), protection.getZ());
        this.blockProtectionMap.put(blockLocation, protection);
    }

    @Override
    public void removeBlockProtection(BlockProtection protection) {
        BlockLocation blockLocation = new BlockLocation(protection.getWorld(), protection.getX(), protection.getY(), protection.getZ());
        this.blockProtectionMap.remove(blockLocation);
    }

    @Override
    public CompletableFuture<EntityProtection> loadEntityProtection(UUID id) {
        return CompletableFuture.completedFuture(this.entityProtectionMap.get(id));
    }

    @Override
    public CompletableFuture<Collection<EntityProtection>> loadEntityProtections() {
        return CompletableFuture.completedFuture(List.copyOf(this.entityProtectionMap.values()));
    }

    @Override
    public void saveEntityProtection(EntityProtection protection) {
        this.entityProtectionMap.put(protection.getId(), protection);
    }

    @Override
    public void removeEntityProtection(EntityProtection protection) {
        this.entityProtectionMap.remove(protection.getId());
    }

    @Override
    public CompletableFuture<Group> loadGroup(String group) {
        return CompletableFuture.completedFuture(this.groupMap.get(group));
    }

    @Override
    public CompletableFuture<Collection<Group>> loadGroups() {
        return CompletableFuture.completedFuture(this.groupMap.values());
    }

    @Override
    public void saveGroup(Group group) {
        this.groupMap.put(group.getName(), group);
    }

    @Override
    public void removeGroup(Group group) {
        this.groupMap.remove(group.getName());
    }

    @Override
    public CompletableFuture<AccessList> loadAccessList(UUID owner) {
        return CompletableFuture.completedFuture(this.accessListMap.get(owner));
    }

    @Override
    public CompletableFuture<Collection<AccessList>> loadAccessLists() {
        return CompletableFuture.completedFuture(this.accessListMap.values());
    }

    @Override
    public void saveAccessList(AccessList accessList) {
        this.accessListMap.put(accessList.getOwner(), accessList);
    }

    @Override
    public void removeAccessList(AccessList accessList) {
        this.accessListMap.remove(accessList.getOwner());
    }

    @Override
    public long pendingSave() {
        return 0L;
    }

    @Override
    public CompletableFuture<Void> flush() {
        return CompletableFuture.completedFuture(null);
    }
}

