/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.access.AccessList;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceTransformer;
import org.popcraft.bolt.source.SourceType;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Protections;
import org.popcraft.bolt.util.SchedulerUtil;

public class TrustCommand
extends BoltCommand {
    public TrustCommand(BoltPlugin plugin) {
        super(plugin);
    }

    public void trustModify(CommandSender sender, UUID uuid, boolean adding, Arguments arguments) {
        String sourceTypeName = arguments.next().toLowerCase();
        SourceType sourceType = this.plugin.getBolt().getSourceTypeRegistry().getSourceByName(sourceTypeName).orElse(null);
        if (sourceType == null || !this.plugin.getBolt().getSourceTypeRegistry().sourceTypes().contains(sourceType)) {
            BoltComponents.sendMessage(sender, "edit_source_invalid", new TagResolver[]{Placeholder.component((String)"source_type", (ComponentLike)Component.text((String)sourceTypeName))});
            return;
        }
        if (sourceType.restricted() && !sender.hasPermission("bolt.type.source.%s".formatted(sourceType.name()))) {
            BoltComponents.sendMessage(sender, "edit_source_no_permission", new TagResolver[0]);
            return;
        }
        String sourceIdentifier = arguments.next();
        String accessType = Objects.requireNonNullElse(arguments.next(), this.plugin.getDefaultAccessType()).toLowerCase();
        Access access = this.plugin.getBolt().getAccessRegistry().getAccessByType(accessType).orElse(null);
        if (access == null) {
            BoltComponents.sendMessage(sender, "edit_access_invalid", new TagResolver[]{Placeholder.component((String)"access_type", (ComponentLike)Component.text((String)accessType))});
            return;
        }
        if (access.restricted() && !sender.hasPermission("bolt.type.access.%s".formatted(access.type()))) {
            BoltComponents.sendMessage(sender, "edit_access_no_permission", new TagResolver[0]);
            return;
        }
        AccessList accessList = Objects.requireNonNullElse(this.plugin.getBolt().getStore().loadAccessList(uuid).join(), new AccessList(uuid, new HashMap<String, String>()));
        SourceTransformer sourceTransformer = this.plugin.getSourceTransformer(sourceType.name());
        sourceTransformer.transformIdentifier(sourceIdentifier).thenAccept(id -> SchedulerUtil.schedule((Plugin)this.plugin, sender, () -> {
            if (id == null) {
                sourceTransformer.sendErrorNotFound(sourceIdentifier, sender);
            } else {
                Source source = Source.of(sourceType.name(), id);
                if (adding) {
                    accessList.getAccess().put(source.toString(), access.type());
                } else {
                    accessList.getAccess().remove(source.toString());
                }
                this.plugin.getBolt().getStore().saveAccessList(accessList);
                BoltComponents.sendMessage(sender, "trust_edited", new TagResolver[0]);
            }
        }));
    }

    public void trustList(CommandSender sender, UUID uuid) {
        AccessList accessList = this.plugin.getBolt().getStore().loadAccessList(uuid).join();
        Map<Object, Object> accessMap = accessList == null ? new HashMap() : accessList.getAccess();
        BoltComponents.sendMessage(sender, "info_self", new TagResolver[]{Placeholder.component((String)"access_list_size", (ComponentLike)Component.text((int)accessMap.size())), Placeholder.component((String)"access_list", (ComponentLike)Protections.accessList(accessMap, sender))});
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (!(sender instanceof Player)) {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            return;
        }
        Player player = (Player)sender;
        String action = arguments.next();
        if ("add".equalsIgnoreCase(action) || "remove".equalsIgnoreCase(action)) {
            if (arguments.remaining() < 2) {
                this.shortHelp(sender, arguments);
                return;
            }
            boolean adding = "add".equalsIgnoreCase(action);
            this.trustModify(sender, player.getUniqueId(), adding, arguments);
        } else {
            this.trustList(sender, player.getUniqueId());
        }
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        String subcommand = arguments.next();
        if (arguments.remaining() == 0) {
            return List.of("add", "remove");
        }
        String sourceType = arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getBolt().getSourceTypeRegistry().sourceTypes().stream().filter(type -> !type.restricted() || sender.hasPermission("bolt.type.source.%s".formatted(type.name()))).map(SourceType::name).toList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getSourceTransformer(sourceType).completions(sender);
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getBolt().getAccessRegistry().access().stream().filter(access -> !access.restricted() || sender.hasPermission("bolt.type.access.%s".formatted(access.type()))).map(Access::type).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_trust", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt trust")), Placeholder.component((String)"literal", (ComponentLike)Component.text((String)"(add|remove)"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_trust", new TagResolver[0]);
    }
}

