/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.util.Action;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.SchedulerUtil;

public class TransferCommand
extends BoltCommand {
    public TransferCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (!(sender instanceof Player)) {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            return;
        }
        Player player = (Player)sender;
        if (arguments.remaining() < 1) {
            this.shortHelp(sender, arguments);
            return;
        }
        String owner = arguments.next();
        Profiles.findOrLookupProfileByName(owner).thenAccept(profile -> {
            if (profile.uuid() != null) {
                this.plugin.player(player).setAction(new Action(Action.Type.TRANSFER, "bolt.command.transfer", profile.uuid().toString()));
                SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "click_transfer", this.plugin.isUseActionBar(), new TagResolver[0]));
            } else {
                SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)owner))}));
            }
        });
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_transfer", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt transfer"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_transfer", new TagResolver[0]);
    }
}

