/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceTransformer;
import org.popcraft.bolt.source.SourceType;
import org.popcraft.bolt.util.Action;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.SchedulerUtil;

public class ModifyCommand
extends BoltCommand {
    public ModifyCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (!(sender instanceof Player)) {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            return;
        }
        Player player = (Player)sender;
        if (arguments.remaining() < 3) {
            this.shortHelp(sender, arguments);
            return;
        }
        BoltPlayer boltPlayer = this.plugin.player(player);
        boolean adding = "add".equalsIgnoreCase(arguments.next());
        String accessType = arguments.next().toLowerCase();
        Access access = this.plugin.getBolt().getAccessRegistry().getAccessByType(accessType).orElse(null);
        if (access == null) {
            BoltComponents.sendMessage(sender, "edit_access_invalid", new TagResolver[]{Placeholder.component((String)"access_type", (ComponentLike)Component.text((String)accessType))});
            return;
        }
        if (access.restricted() && !sender.hasPermission("bolt.type.access.%s".formatted(access.type()))) {
            BoltComponents.sendMessage(sender, "edit_access_no_permission", new TagResolver[0]);
            return;
        }
        String sourceTypeName = arguments.next().toLowerCase();
        SourceType sourceType = this.plugin.getBolt().getSourceTypeRegistry().getSourceByName(sourceTypeName).orElse(null);
        if (sourceType == null || !this.plugin.getBolt().getSourceTypeRegistry().sourceTypes().contains(sourceType)) {
            BoltComponents.sendMessage(sender, "edit_source_invalid", new TagResolver[]{Placeholder.component((String)"source_type", (ComponentLike)Component.text((String)sourceTypeName))});
            return;
        }
        if (sourceType.restricted() && !sender.hasPermission("bolt.type.source.%s".formatted(sourceType.name()))) {
            BoltComponents.sendMessage(sender, "edit_source_no_permission", new TagResolver[0]);
            return;
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        if (sourceType.unique()) {
            identifiers.add(sourceType.name());
        } else {
            String identifier;
            if (arguments.remaining() < 1) {
                this.shortHelp(sender, arguments);
                return;
            }
            while ((identifier = arguments.next()) != null) {
                identifiers.add(identifier);
            }
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (String identifier : identifiers) {
            SourceTransformer sourceTransformer = this.plugin.getSourceTransformer(sourceType.name());
            futures.add(sourceTransformer.transformIdentifier(identifier).thenAccept(id -> SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> {
                if (id == null) {
                    sourceTransformer.sendErrorNotFound(identifier, (CommandSender)player);
                } else {
                    boltPlayer.getModifications().put(Source.of(sourceType.name(), id), access.type());
                }
            })));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> {
            if (boltPlayer.getModifications().isEmpty()) {
                return;
            }
            boltPlayer.setAction(new Action(Action.Type.EDIT, "bolt.command.edit", Boolean.toString(adding)));
            BoltComponents.sendMessage((CommandSender)player, "click_action", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"action", (ComponentLike)BoltComponents.resolveTranslation("edit", (CommandSender)player, new TagResolver[0]))});
        }));
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        String added;
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return List.of("add", "remove");
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getBolt().getAccessRegistry().access().stream().filter(access -> !access.restricted() || sender.hasPermission("bolt.type.access.%s".formatted(access.type()))).map(Access::type).toList();
        }
        String sourceType = arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getBolt().getSourceTypeRegistry().sourceTypes().stream().filter(type -> !type.restricted() || sender.hasPermission("bolt.type.source.%s".formatted(type.name()))).map(SourceType::name).toList();
        }
        HashSet<String> alreadyAdded = new HashSet<String>();
        while ((added = arguments.next()) != null) {
            alreadyAdded.add(added);
        }
        return this.plugin.getSourceTransformer(sourceType).completions(sender).stream().filter(name -> !alreadyAdded.contains(name)).toList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_modify", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt modify")), Placeholder.component((String)"literal", (ComponentLike)Component.text((String)"(add|remove)"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_modify", new TagResolver[0]);
    }
}

