/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.Mode;

public class ModeCommand
extends BoltCommand {
    public ModeCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (sender instanceof Player) {
            Mode mode;
            Player player = (Player)sender;
            BoltPlayer boltPlayer = this.plugin.player(player);
            String modeArgument = arguments.next();
            if (modeArgument == null) {
                BoltComponents.sendMessage((CommandSender)player, "mode_invalid", new TagResolver[0]);
                return;
            }
            try {
                mode = Mode.valueOf(modeArgument.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                BoltComponents.sendMessage((CommandSender)player, "mode_invalid", new TagResolver[0]);
                return;
            }
            boltPlayer.toggleMode(mode);
            boolean hasMode = boltPlayer.hasMode(mode);
            BoltComponents.sendMessage((CommandSender)player, hasMode ? "mode_enabled" : "mode_disabled", new TagResolver[]{Placeholder.component((String)"mode", (ComponentLike)BoltComponents.resolveTranslation("mode_%s".formatted(mode.name().toLowerCase()), (CommandSender)player, new TagResolver[0]))});
            UUID uuid = player.getUniqueId();
            CompletableFuture.runAsync(() -> {
                File playerFile = this.plugin.getDataPath().resolve("players/%s.yml".formatted(uuid)).toFile();
                YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                playerConfig.set(mode.name().toLowerCase(), (Object)hasMode);
                try {
                    playerConfig.save(playerFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        } else {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
        }
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return Arrays.stream(Mode.values()).map(mode -> mode.name().toLowerCase()).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_mode", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt mode"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_mode", new TagResolver[0]);
    }
}

