/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.util.Action;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;

public class LockCommand
extends BoltCommand {
    public LockCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (sender instanceof Player) {
            boolean force;
            Player player = (Player)sender;
            BoltPlayer boltPlayer = this.plugin.player(player);
            String argument = arguments.next();
            String type = argument == null ? this.plugin.getDefaultProtectionType() : argument.toLowerCase();
            Access access = this.plugin.getBolt().getAccessRegistry().getProtectionByType(type).orElse(null);
            if (access == null) {
                BoltComponents.sendMessage(sender, "click_locked_no_exist", new TagResolver[]{Placeholder.component((String)"protection_type", (ComponentLike)Component.text((String)type))});
                return;
            }
            if (access.restricted() && !sender.hasPermission("bolt.type.protection.%s".formatted(access.type()))) {
                BoltComponents.sendMessage(sender, "click_locked_no_permission", new TagResolver[0]);
                return;
            }
            boolean argumentsRemaining = arguments.remaining() > 0;
            boolean bl = force = "force".equalsIgnoreCase(arguments.next()) && sender.hasPermission("bolt.admin");
            if (BoltPlugin.DEBUG && argumentsRemaining && !force) {
                boltPlayer.setLockNil(true);
            }
            boltPlayer.setAction(new Action(Action.Type.LOCK, "bolt.command.lock", type, force));
            BoltComponents.sendMessage((CommandSender)player, "click_action", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"action", (ComponentLike)BoltComponents.resolveTranslation("lock", (CommandSender)player, new TagResolver[0]))});
        } else {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
        }
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getBolt().getAccessRegistry().protections().stream().filter(protection -> !protection.restricted() || sender.hasPermission("bolt.type.protection.%s".formatted(protection.type()))).map(Access::type).toList();
        }
        arguments.next();
        if (arguments.remaining() == 0 && sender.hasPermission("bolt.admin")) {
            return List.of("force");
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_lock", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt lock"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_lock", new TagResolver[0]);
    }
}

