/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.command.impl.AdminCommand;
import org.popcraft.bolt.util.BoltComponents;

public class HelpCommand
extends BoltCommand {
    public HelpCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        String command = arguments.next();
        if (command == null) {
            this.shortHelp(sender, arguments);
            this.longHelp(sender, arguments);
            return;
        }
        BoltCommand boltCommand = this.plugin.commands().get(command);
        if (boltCommand == null) {
            BoltComponents.sendMessage(sender, "command_invalid", new TagResolver[0]);
            return;
        }
        Arguments shortCopy = arguments.copy();
        Arguments longCopy = arguments.copy();
        String subCommand = arguments.next();
        BoltCommand finalCommand = "admin".equals(command) && subCommand != null ? AdminCommand.SUB_COMMANDS.get(subCommand) : boltCommand;
        finalCommand.shortHelp(sender, shortCopy);
        finalCommand.longHelp(sender, longCopy);
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        String command = arguments.next();
        if (arguments.remaining() == 0) {
            return new ArrayList<String>(this.plugin.commands().keySet());
        }
        arguments.next();
        if (arguments.remaining() == 0 && "admin".equals(command)) {
            return new ArrayList<String>(AdminCommand.SUB_COMMANDS.keySet());
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_help", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt help"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_help", new TagResolver[0]);
    }
}

