/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.data.Profile;
import org.popcraft.bolt.data.Store;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Group;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.SchedulerUtil;

public class GroupCommand
extends BoltCommand {
    public GroupCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        String member;
        if (!(sender instanceof Player)) {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            return;
        }
        Player player = (Player)sender;
        if (arguments.remaining() < 2) {
            this.shortHelp(sender, arguments);
            return;
        }
        String action = arguments.next().toLowerCase();
        String group = arguments.next();
        ArrayList<String> members = new ArrayList<String>();
        while ((member = arguments.next()) != null) {
            members.add(member);
        }
        Profiles.findOrLookupProfilesByNames(members).thenAccept(profiles -> {
            Store store = this.plugin.getBolt().getStore();
            Group existingGroup = store.loadGroup(group).join();
            List<Profile> completeProfiles = profiles.stream().filter(Profile::complete).toList();
            ArrayList<UUID> uuids = new ArrayList<UUID>(completeProfiles.stream().map(Profile::uuid).toList());
            ArrayList<String> names = new ArrayList<String>(completeProfiles.stream().map(Profile::name).toList());
            switch (action) {
                case "create": {
                    if (existingGroup != null) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_already_exists", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    store.saveGroup(new Group(group, player.getUniqueId(), uuids));
                    SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_created", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                    break;
                }
                case "delete": {
                    if (existingGroup == null) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_doesnt_exist", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    if (!existingGroup.getOwner().equals(player.getUniqueId())) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_not_owner", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    store.removeGroup(existingGroup);
                    SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_deleted", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                    break;
                }
                case "add": {
                    if (existingGroup == null) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_doesnt_exist", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    if (!existingGroup.getOwner().equals(player.getUniqueId())) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_not_owner", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    existingGroup.getMembers().addAll(uuids);
                    store.saveGroup(existingGroup);
                    names.forEach(name -> SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_player_add", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)name)), Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))})));
                    break;
                }
                case "remove": {
                    if (existingGroup == null) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_doesnt_exist", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    if (!existingGroup.getOwner().equals(player.getUniqueId())) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_not_owner", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    existingGroup.getMembers().removeAll(uuids);
                    store.saveGroup(existingGroup);
                    names.forEach(name -> SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_player_remove", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)name)), Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))})));
                    break;
                }
                case "list": {
                    if (existingGroup == null) {
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_doesnt_exist", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group))}));
                        break;
                    }
                    Profiles.findOrLookupProfilesByUniqueIds(existingGroup.getMembers()).thenAccept(existingProfiles -> {
                        List<String> memberNames = existingProfiles.stream().filter(Profile::complete).map(Profile::name).toList();
                        String memberList = String.join((CharSequence)", ", memberNames);
                        SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "group_list_members", new TagResolver[]{Placeholder.component((String)"group", (ComponentLike)Component.text((String)group)), Placeholder.component((String)"group_members", (ComponentLike)Component.text((String)memberList))}));
                    });
                }
            }
        });
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        String added;
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return List.of("create", "delete", "add", "remove", "list");
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return this.plugin.getPlayersOwnedGroups(player);
            }
            return Collections.emptyList();
        }
        HashSet<String> alreadyAdded = new HashSet<String>();
        while ((added = arguments.next()) != null) {
            alreadyAdded.add(added);
        }
        return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> !alreadyAdded.contains(name)).toList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_group", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt group")), Placeholder.component((String)"literal", (ComponentLike)Component.text((String)"(create|delete|add|remove|list)"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_group", new TagResolver[0]);
    }
}

