/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.util.Action;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.SchedulerUtil;

public class EditCommand
extends BoltCommand {
    public EditCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (!(sender instanceof Player)) {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            return;
        }
        Player player = (Player)sender;
        if (arguments.remaining() < 2) {
            this.shortHelp(sender, arguments);
            return;
        }
        BoltPlayer boltPlayer = this.plugin.player(player);
        boolean adding = "add".equalsIgnoreCase(arguments.next());
        String target = arguments.next();
        Profiles.findOrLookupProfileByName(target).thenAccept(playerProfile -> SchedulerUtil.schedule((Plugin)this.plugin, sender, () -> {
            if (!playerProfile.complete()) {
                BoltComponents.sendMessage(sender, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)target))});
                return;
            }
            Source source = Source.player(playerProfile.uuid());
            boltPlayer.setAction(new Action(Action.Type.EDIT, "bolt.command.edit", Boolean.toString(adding)));
            boltPlayer.getModifications().put(source, this.plugin.getDefaultAccessType());
            BoltComponents.sendMessage((CommandSender)player, "click_action", this.plugin.isUseActionBar(), new TagResolver[]{Placeholder.component((String)"action", (ComponentLike)BoltComponents.resolveTranslation("edit", (CommandSender)player, new TagResolver[0]))});
        }));
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return List.of("add", "remove");
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_edit", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt edit")), Placeholder.component((String)"literal", (ComponentLike)Component.text((String)"(add|remove)"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_edit", new TagResolver[0]);
    }
}

