/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.impl.TrustCommand;
import org.popcraft.bolt.source.SourceType;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.SchedulerUtil;

public class AdminTrustCommand
extends TrustCommand {
    public AdminTrustCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        String target = arguments.next();
        Profiles.findOrLookupProfileByName(target).thenAccept(profile -> {
            if (profile.uuid() != null) {
                String action = arguments.next();
                if ("add".equalsIgnoreCase(action) || "remove".equalsIgnoreCase(action)) {
                    if (arguments.remaining() < 2) {
                        this.shortHelp(sender, arguments);
                        return;
                    }
                    boolean adding = "add".equalsIgnoreCase(action);
                    super.trustModify(sender, profile.uuid(), adding, arguments);
                } else {
                    super.trustList(sender, profile.uuid());
                }
            } else {
                SchedulerUtil.schedule((Plugin)this.plugin, sender, () -> BoltComponents.sendMessage(sender, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)target))}));
            }
        });
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toList();
        }
        String subcommand = arguments.next();
        if (arguments.remaining() == 0) {
            return List.of("add", "remove", "list");
        }
        if ("list".equalsIgnoreCase(subcommand)) {
            return Collections.emptyList();
        }
        String sourceType = arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getBolt().getSourceTypeRegistry().sourceTypes().stream().filter(type -> !type.restricted() || sender.hasPermission("bolt.type.source.%s".formatted(type.name()))).map(SourceType::name).toList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getSourceTransformer(sourceType).completions(sender);
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getBolt().getAccessRegistry().access().stream().filter(access -> !access.restricted() || sender.hasPermission("bolt.type.access.%s".formatted(access.type()))).map(Access::type).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_trust", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin trust")), Placeholder.component((String)"literal", (ComponentLike)Component.text((String)"(add|remove|list)"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_trust", new TagResolver[0]);
    }
}

