/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.data.Profile;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.util.Action;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.SchedulerUtil;

public class AdminTransferCommand
extends BoltCommand {
    public AdminTransferCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (!(sender instanceof Player)) {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            return;
        }
        Player player = (Player)sender;
        if (arguments.remaining() < 1) {
            this.shortHelp(sender, arguments);
            return;
        }
        String owner = arguments.next();
        String newOwner = arguments.next();
        CompletableFuture<Profile> ownerProfileFuture = Profiles.findOrLookupProfileByName(owner);
        CompletableFuture<Profile> newOwnerProfileFuture = Profiles.findOrLookupProfileByName(newOwner);
        if (newOwner != null) {
            CompletableFuture.allOf(ownerProfileFuture, newOwnerProfileFuture).thenRun(() -> {
                Profile ownerProfile = (Profile)ownerProfileFuture.join();
                Profile newOwnerProfile = (Profile)newOwnerProfileFuture.join();
                if (ownerProfile.uuid() == null) {
                    SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)owner))}));
                } else if (newOwnerProfile.uuid() == null) {
                    SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)newOwner))}));
                } else {
                    this.plugin.loadProtections().stream().filter(protection -> protection.getOwner().equals(ownerProfile.uuid())).forEach(protection -> {
                        protection.setOwner(newOwnerProfile.uuid());
                        this.plugin.saveProtection((Protection)protection);
                    });
                    SchedulerUtil.schedule((Plugin)this.plugin, (CommandSender)player, () -> BoltComponents.sendMessage((CommandSender)player, "click_transfer_all", new TagResolver[]{Placeholder.component((String)"old_player", (ComponentLike)Component.text((String)owner)), Placeholder.component((String)"new_player", (ComponentLike)Component.text((String)newOwner))}));
                }
            });
        } else {
            ownerProfileFuture.thenAccept(profile -> {
                if (profile.uuid() != null) {
                    this.plugin.player(player).setAction(new Action(Action.Type.TRANSFER, "bolt.command.admin.transfer", profile.uuid().toString(), true));
                    BoltComponents.sendMessage((CommandSender)player, "click_transfer", this.plugin.isUseActionBar(), new TagResolver[0]);
                } else {
                    BoltComponents.sendMessage((CommandSender)player, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)owner))});
                }
            });
        }
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_transfer", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin transfer"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_transfer", new TagResolver[0]);
    }
}

