/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.data.SQLStore;
import org.popcraft.bolt.data.Store;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.SchedulerUtil;

public class AdminStorageCommand
extends BoltCommand {
    private final AtomicBoolean isConverting = new AtomicBoolean();

    public AdminStorageCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        String method = arguments.next();
        if (!"export".equalsIgnoreCase(method) && !"import".equalsIgnoreCase(method)) {
            this.shortHelp(sender, arguments);
            return;
        }
        if (this.isConverting.get()) {
            BoltComponents.sendMessage(sender, "storage_in_progress", new TagResolver[0]);
            return;
        }
        Path exportPath = this.plugin.getDataPath().resolve("export.db");
        SQLStore.Configuration databaseConfiguration = new SQLStore.Configuration("sqlite", exportPath.toString(), "", "", "", "", "", Map.of());
        Store currentStore = this.plugin.getBolt().getStore();
        if ("export".equalsIgnoreCase(method)) {
            if (Files.exists(exportPath, new LinkOption[0])) {
                BoltComponents.sendMessage(sender, "storage_export_exists", new TagResolver[0]);
                return;
            }
            SQLStore exportStore = new SQLStore(databaseConfiguration);
            BoltComponents.sendMessage(sender, "storage_export_started", new TagResolver[0]);
            this.isConverting.set(true);
            this.transfer(currentStore, exportStore).whenCompleteAsync((v, throwable) -> {
                this.isConverting.set(false);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                BoltComponents.sendMessage(sender, "storage_export_completed", new TagResolver[0]);
                exportStore.close();
            }, SchedulerUtil.executor((Plugin)this.plugin, sender));
        } else {
            if (!Files.exists(exportPath, new LinkOption[0])) {
                BoltComponents.sendMessage(sender, "storage_import_doesnt_exist", new TagResolver[0]);
                return;
            }
            SQLStore exportStore = new SQLStore(databaseConfiguration);
            BoltComponents.sendMessage(sender, "storage_import_started", new TagResolver[0]);
            this.isConverting.set(true);
            this.transfer(exportStore, currentStore).whenCompleteAsync((v, throwable) -> {
                this.isConverting.set(false);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                BoltComponents.sendMessage(sender, "storage_import_completed", new TagResolver[0]);
                exportStore.close();
            }, SchedulerUtil.executor((Plugin)this.plugin, sender));
        }
    }

    private CompletableFuture<Void> transfer(Store from, Store to) {
        return CompletableFuture.runAsync(() -> {
            from.loadBlockProtections().join().forEach(to::saveBlockProtection);
            from.loadEntityProtections().join().forEach(to::saveEntityProtection);
            from.loadGroups().join().forEach(to::saveGroup);
            from.loadAccessLists().join().forEach(to::saveAccessList);
            to.flush().join();
        });
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        return List.of("export", "import");
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_storage", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin storage")), Placeholder.component((String)"literal", (ComponentLike)Component.text((String)"(export|import)"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_storage", new TagResolver[0]);
    }
}

