/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Metrics;

public class AdminReportCommand
extends BoltCommand {
    private final Map<Metrics.ProtectionAccess, Long> previousExecutionCounts = new HashMap<Metrics.ProtectionAccess, Long>();
    private long previousHits;
    private long previousMisses;

    public AdminReportCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        boolean disable;
        if (!Metrics.isEnabled()) {
            Metrics.setEnabled(true);
            BoltComponents.sendMessage(sender, "Enabling reports. This will have a performance impact. Type '/bolt admin report disable' to turn off reports. Type '/bolt admin report' again to generate an updated report.", new TagResolver[0]);
            return;
        }
        boolean bl = disable = arguments.next() != null;
        if (disable) {
            Metrics.setEnabled(false);
            this.previousHits = 0L;
            this.previousMisses = 0L;
            this.previousExecutionCounts.clear();
            BoltComponents.sendMessage(sender, "Disabling reports.", new TagResolver[0]);
            return;
        }
        long hits = Metrics.getProtectionHits();
        long misses = Metrics.getProtectionMisses();
        boolean hitsChanged = hits != this.previousHits;
        boolean missesChanged = misses != this.previousMisses;
        BoltComponents.sendMessage(sender, "Hits: <hits>", new TagResolver[]{Placeholder.component((String)"hits", (ComponentLike)this.changeComponent(hitsChanged, this.previousHits, hits))});
        BoltComponents.sendMessage(sender, "Misses: <misses>", new TagResolver[]{Placeholder.component((String)"misses", (ComponentLike)this.changeComponent(missesChanged, this.previousMisses, misses))});
        Map<Metrics.ProtectionAccess, Long> protectionAccessCounts = Metrics.getProtectionAccessCounts();
        Map protectionAccessListByType = protectionAccessCounts.keySet().stream().collect(Collectors.groupingBy(Metrics.ProtectionAccess::type, Collectors.toList()));
        protectionAccessListByType.forEach((type, list) -> {
            BoltComponents.sendMessage(sender, "<type>", new TagResolver[]{Placeholder.component((String)"type", (ComponentLike)Component.text((String)type))});
            list.forEach(protectionAccess -> {
                long previousCount;
                long count = (Long)protectionAccessCounts.get(protectionAccess);
                boolean countChanged = count != (previousCount = this.previousExecutionCounts.getOrDefault(protectionAccess, 0L).longValue());
                BoltComponents.sendMessage(sender, "<consumer>: <count>", new TagResolver[]{Placeholder.component((String)"consumer", (ComponentLike)Component.text((String)protectionAccess.consumer())), Placeholder.component((String)"count", (ComponentLike)this.changeComponent(countChanged, previousCount, count))});
            });
        });
        this.previousHits = hits;
        this.previousMisses = misses;
        this.previousExecutionCounts.clear();
        this.previousExecutionCounts.putAll(protectionAccessCounts);
    }

    private Component changeComponent(boolean changed, long before, long after) {
        return ((TextComponent)Component.empty().append((Component)Component.text((String)(changed ? "%d -> ".formatted(before) : "")))).append(Component.text((long)after).color((TextColor)(changed ? NamedTextColor.RED : NamedTextColor.WHITE)));
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (Metrics.isEnabled()) {
            return List.of("disable");
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_report", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin report")), Placeholder.component((String)"literal", (ComponentLike)Component.text((String)"[disable]"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_report", new TagResolver[0]);
    }
}

