/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.SchedulerUtil;

public class AdminPurgeCommand
extends BoltCommand {
    public AdminPurgeCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() < 1) {
            this.shortHelp(sender, arguments);
            return;
        }
        String owner = arguments.next();
        Profiles.findOrLookupProfileByName(owner).thenAccept(profile -> {
            if (profile.uuid() != null) {
                this.plugin.loadProtections().stream().filter(protection -> protection.getOwner().equals(profile.uuid())).forEach(this.plugin::removeProtection);
                SchedulerUtil.schedule((Plugin)this.plugin, sender, () -> BoltComponents.sendMessage(sender, "purge", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)owner))}));
            } else {
                SchedulerUtil.schedule((Plugin)this.plugin, sender, () -> BoltComponents.sendMessage(sender, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)owner))}));
            }
        });
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_purge", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin purge"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_purge", new TagResolver[0]);
    }
}

