/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Pagination;

public class AdminNearbyCommand
extends BoltCommand {
    public AdminNearbyCommand(BoltPlugin plugin) {
        super(plugin);
    }

    private Location protectionLocation(Protection protection) {
        Protection protection2 = protection;
        Objects.requireNonNull(protection2);
        Protection protection3 = protection2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockProtection.class, EntityProtection.class}, (Object)protection3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                BlockProtection block = (BlockProtection)protection3;
                yield new Location(this.plugin.getServer().getWorld(block.getWorld()), (double)block.getX() + 0.5, (double)block.getY(), (double)block.getZ() + 0.5);
            }
            case 1 -> {
                EntityProtection entityProtection = (EntityProtection)protection3;
                Entity entity = this.plugin.getServer().getEntity(entityProtection.getId());
                if (entity == null) {
                    yield null;
                }
                yield entity.getLocation();
            }
        };
    }

    private double distance(Location a, Protection protection) {
        Location b = this.protectionLocation(protection);
        if (a == null || b == null || a.getWorld() == null || b.getWorld() == null || !a.getWorld().equals((Object)b.getWorld())) {
            return Double.NaN;
        }
        return a.distance(b);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (!(sender instanceof Player)) {
            BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            return;
        }
        Player player = (Player)sender;
        Integer limit = arguments.nextAsInteger();
        if (limit == null) {
            this.shortHelp(sender, arguments);
            return;
        }
        Location playerLocation = player.getLocation();
        List<Protection> closestProtections = this.plugin.loadProtections().stream().filter(protection -> {
            double d = this.distance(playerLocation, (Protection)protection);
            return !Double.isNaN(d) && d < (double)limit.intValue();
        }).sorted(Comparator.comparingDouble(protection -> this.distance(playerLocation, (Protection)protection))).toList();
        Pagination.runPage(this.plugin, sender, closestProtections, 0);
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_nearby", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin nearby"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_nearby", new TagResolver[0]);
    }
}

