/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.Pagination;
import org.popcraft.bolt.util.Profiles;
import org.popcraft.bolt.util.SchedulerUtil;

public class AdminFindCommand
extends BoltCommand {
    public AdminFindCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() < 1) {
            this.shortHelp(sender, arguments);
            return;
        }
        String player = arguments.next();
        Profiles.findOrLookupProfileByName(player).thenAccept(playerProfile -> SchedulerUtil.schedule((Plugin)this.plugin, sender, () -> {
            if (!playerProfile.complete()) {
                BoltComponents.sendMessage(sender, "player_not_found", new TagResolver[]{Placeholder.component((String)"player", (ComponentLike)Component.text((String)player))});
                return;
            }
            List<Protection> protectionsFromPlayer = this.plugin.loadProtections().stream().filter(protection -> playerProfile.uuid().equals(protection.getOwner())).sorted(Comparator.comparingLong(Protection::getCreated).reversed()).toList();
            Pagination.runPage(this.plugin, sender, protectionsFromPlayer, 0);
        }));
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_find", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin find"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_find", new TagResolver[0]);
    }
}

