/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.data.Store;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.util.BoltComponents;

public class AdminExpireCommand
extends BoltCommand {
    public AdminExpireCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        Store store = this.plugin.getBolt().getStore();
        Collection<BlockProtection> protections = store.loadBlockProtections().join();
        long now = System.currentTimeMillis();
        Integer timeValue = arguments.nextAsInteger();
        TimeUnit timeUnit = Optional.ofNullable(arguments.next()).map(arg -> {
            try {
                return TimeUnit.valueOf(arg.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).orElse(null);
        if (timeValue == null || timeUnit == null) {
            BoltComponents.sendMessage(sender, "expire_invalid_time", new TagResolver[0]);
            return;
        }
        long timeDiffMillis = TimeUnit.MILLISECONDS.convert(timeValue.intValue(), timeUnit);
        long expireTime = now - timeDiffMillis;
        long removed = 0L;
        for (BlockProtection blockProtection : protections) {
            long lastAccessed = blockProtection.getAccessed();
            if (lastAccessed <= 0L || lastAccessed >= expireTime) continue;
            store.removeBlockProtection(blockProtection);
            ++removed;
        }
        BoltComponents.sendMessage(sender, "expire_complete", new TagResolver[]{Placeholder.component((String)"count", (ComponentLike)Component.text((long)removed))});
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_expire", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin expire"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_expire", new TagResolver[0]);
    }
}

