/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.data.migration.lockette.LocketteMigration;
import org.popcraft.bolt.data.migration.lwc.BoltMigration;
import org.popcraft.bolt.data.migration.lwc.LWCMigration;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.SchedulerUtil;

public class AdminConvertCommand
extends BoltCommand {
    private final Set<String> locketteNames = Set.of("lockette", "lockettepro", "deadbolt", "blocklocker");
    private final AtomicBoolean isConverting = new AtomicBoolean();
    private LWCMigration lastMigration;

    public AdminConvertCommand(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        boolean lockette;
        if (this.isConverting.get()) {
            BoltComponents.sendMessage(sender, "migration_in_progress", new TagResolver[0]);
            return;
        }
        String arg = arguments.next();
        boolean convertEntities = "entities".equalsIgnoreCase(arg);
        if (this.lastMigration != null && convertEntities) {
            BoltComponents.sendMessage(sender, "migration_started", new TagResolver[]{Placeholder.component((String)"old_plugin", (ComponentLike)Component.text((String)"LWC")), Placeholder.component((String)"new_plugin", (ComponentLike)Component.text((String)"Bolt"))});
            this.isConverting.set(true);
            this.lastMigration.convertEntityBlocks().whenCompleteAsync((memoryStore, throwable) -> {
                this.isConverting.set(false);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                for (EntityProtection entityProtection : memoryStore.loadEntityProtections().join()) {
                    this.plugin.saveProtection(entityProtection);
                }
                BoltComponents.sendMessage(sender, "migration_completed", new TagResolver[0]);
            }, SchedulerUtil.executor((Plugin)this.plugin, sender));
            this.lastMigration = null;
            return;
        }
        boolean convertBolt = "bolt".equalsIgnoreCase(arg);
        boolean bl = lockette = arg != null && this.locketteNames.contains(arg.toLowerCase());
        if (convertBolt) {
            if (!this.plugin.getServer().getPluginManager().isPluginEnabled("LWC")) {
                BoltComponents.sendMessage(sender, "migration_lwc_missing", new TagResolver[0]);
                return;
            }
            BoltMigration migration = new BoltMigration(this.plugin);
            BoltComponents.sendMessage(sender, "migration_started", new TagResolver[]{Placeholder.component((String)"old_plugin", (ComponentLike)Component.text((String)"Bolt")), Placeholder.component((String)"new_plugin", (ComponentLike)Component.text((String)"LWC"))});
            this.isConverting.set(true);
            migration.convertAsync().whenCompleteAsync((ignored, throwable) -> {
                this.isConverting.set(false);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                BoltComponents.sendMessage(sender, "migration_completed", new TagResolver[0]);
            }, SchedulerUtil.executor((Plugin)this.plugin, sender));
        } else if (lockette) {
            LocketteMigration migration = new LocketteMigration(this.plugin);
            String pluginName = switch (arg.toLowerCase()) {
                case "lockette" -> "Lockette";
                case "lockettepro" -> "LockettePro";
                case "deadbolt" -> "DeadBolt";
                case "blocklocker" -> "BlockLocker";
                default -> throw new IllegalStateException();
            };
            BoltComponents.sendMessage(sender, "migration_started", new TagResolver[]{Placeholder.component((String)"old_plugin", (ComponentLike)Component.text((String)pluginName)), Placeholder.component((String)"new_plugin", (ComponentLike)Component.text((String)"Bolt"))});
            this.isConverting.set(true);
            migration.convertAsync().whenCompleteAsync((memoryStore, throwable) -> {
                this.isConverting.set(false);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                for (BlockProtection blockProtection : memoryStore.loadBlockProtections().join()) {
                    this.plugin.saveProtection(blockProtection);
                }
                BoltComponents.sendMessage(sender, "migration_completed", new TagResolver[0]);
            }, SchedulerUtil.executor((Plugin)this.plugin, sender));
        } else {
            LWCMigration migration = new LWCMigration(this.plugin);
            BoltComponents.sendMessage(sender, "migration_started", new TagResolver[]{Placeholder.component((String)"old_plugin", (ComponentLike)Component.text((String)"LWC")), Placeholder.component((String)"new_plugin", (ComponentLike)Component.text((String)"Bolt"))});
            this.isConverting.set(true);
            migration.convertAsync().whenCompleteAsync((memoryStore, throwable) -> {
                this.isConverting.set(false);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                for (BlockProtection blockProtection : memoryStore.loadBlockProtections().join()) {
                    this.plugin.saveProtection(blockProtection);
                }
                for (EntityProtection entityProtection : memoryStore.loadEntityProtections().join()) {
                    this.plugin.saveProtection(entityProtection);
                }
                BoltComponents.sendMessage(sender, "migration_completed", new TagResolver[0]);
                if (migration.hasEntityBlocks()) {
                    this.lastMigration = migration;
                    BoltComponents.sendMessage(sender, "migration_completed_found_entities", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin convert entities"))});
                }
            }, SchedulerUtil.executor((Plugin)this.plugin, sender));
        }
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        if (arguments.remaining() == 0) {
            return Collections.emptyList();
        }
        arguments.next();
        if (arguments.remaining() == 0) {
            ArrayList<String> suggestions = new ArrayList<String>(List.of("lwc", "bolt"));
            suggestions.addAll(this.locketteNames);
            if (this.lastMigration != null && this.lastMigration.hasEntityBlocks()) {
                suggestions.add("entities");
            }
            return suggestions;
        }
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_convert", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin convert"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_convert", new TagResolver[0]);
    }
}

