/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.command.impl.AdminCleanup;
import org.popcraft.bolt.command.impl.AdminConvertCommand;
import org.popcraft.bolt.command.impl.AdminDebugCommand;
import org.popcraft.bolt.command.impl.AdminExpireCommand;
import org.popcraft.bolt.command.impl.AdminFindCommand;
import org.popcraft.bolt.command.impl.AdminFlushCommand;
import org.popcraft.bolt.command.impl.AdminNearbyCommand;
import org.popcraft.bolt.command.impl.AdminPurgeCommand;
import org.popcraft.bolt.command.impl.AdminReloadCommand;
import org.popcraft.bolt.command.impl.AdminReportCommand;
import org.popcraft.bolt.command.impl.AdminStorageCommand;
import org.popcraft.bolt.command.impl.AdminTransferCommand;
import org.popcraft.bolt.command.impl.AdminTrustCommand;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.util.BoltComponents;

public class AdminCommand
extends BoltCommand {
    public static final Map<String, BoltCommand> SUB_COMMANDS = new HashMap<String, BoltCommand>();
    private static final String COMMAND_PERMISSION_KEY = "bolt.command.admin.";

    public AdminCommand(BoltPlugin plugin) {
        super(plugin);
        SUB_COMMANDS.clear();
        SUB_COMMANDS.putAll(Map.ofEntries(Map.entry("cleanup", new AdminCleanup(plugin)), Map.entry("convert", new AdminConvertCommand(plugin)), Map.entry("debug", new AdminDebugCommand(plugin)), Map.entry("expire", new AdminExpireCommand(plugin)), Map.entry("find", new AdminFindCommand(plugin)), Map.entry("flush", new AdminFlushCommand(plugin)), Map.entry("nearby", new AdminNearbyCommand(plugin)), Map.entry("purge", new AdminPurgeCommand(plugin)), Map.entry("reload", new AdminReloadCommand(plugin)), Map.entry("report", new AdminReportCommand(plugin)), Map.entry("storage", new AdminStorageCommand(plugin)), Map.entry("transfer", new AdminTransferCommand(plugin)), Map.entry("trust", new AdminTrustCommand(plugin))));
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        String subcommand = arguments.next();
        if (subcommand == null) {
            Collection<Protection> protections = this.plugin.loadProtections();
            long blockCount = protections.stream().filter(BlockProtection.class::isInstance).count();
            long entityCount = protections.stream().filter(EntityProtection.class::isInstance).count();
            BoltComponents.sendMessage(sender, "status", new TagResolver[]{Placeholder.component((String)"count_blocks", (ComponentLike)Component.text((long)blockCount)), Placeholder.component((String)"count_entities", (ComponentLike)Component.text((long)entityCount))});
            return;
        }
        if (!SUB_COMMANDS.containsKey(subcommand)) {
            return;
        }
        if (!sender.hasPermission(COMMAND_PERMISSION_KEY + subcommand)) {
            BoltComponents.sendMessage(sender, "command_no_permission", new TagResolver[0]);
            return;
        }
        SUB_COMMANDS.get(subcommand).execute(sender, arguments);
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        String subcommand = arguments.next();
        if (!SUB_COMMANDS.containsKey(subcommand)) {
            return SUB_COMMANDS.entrySet().stream().filter(i -> sender.hasPermission(COMMAND_PERMISSION_KEY + (String)i.getKey()) && !((BoltCommand)i.getValue()).hidden()).map(Map.Entry::getKey).toList();
        }
        if (SUB_COMMANDS.containsKey(subcommand) && sender.hasPermission(COMMAND_PERMISSION_KEY + subcommand)) {
            return SUB_COMMANDS.get(subcommand).suggestions(sender, arguments);
        }
        return List.of();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        String subcommand = arguments.next();
        if (!SUB_COMMANDS.containsKey(subcommand)) {
            BoltComponents.sendMessage(sender, "help_command_short_admin", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin"))});
            return;
        }
        SUB_COMMANDS.get(subcommand).shortHelp(sender, arguments);
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        String subcommand = arguments.next();
        if (!SUB_COMMANDS.containsKey(subcommand)) {
            BoltComponents.sendMessage(sender, "help_command_long_admin", new TagResolver[0]);
            return;
        }
        SUB_COMMANDS.get(subcommand).longHelp(sender, arguments);
    }
}

