/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.data.Store;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.ChunkPos;
import org.popcraft.bolt.util.Protections;
import org.popcraft.bolt.util.SchedulerUtil;

public class AdminCleanup
extends BoltCommand {
    private static final int PERMITS = 10;
    private static final Semaphore WORKING = new Semaphore(10);

    public AdminCleanup(BoltPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(CommandSender sender, Arguments arguments) {
        Store store = this.plugin.getBolt().getStore();
        Collection<BlockProtection> protections = store.loadBlockProtections().join();
        long count = protections.size();
        BoltComponents.sendMessage(sender, "cleanup_start", new TagResolver[]{Placeholder.component((String)"count", (ComponentLike)Component.text((long)count))});
        HashMap<String, World> worlds = new HashMap<String, World>();
        HashMap<ChunkPos, List> blockProtectionsByChunk = new HashMap<ChunkPos, List>();
        long start = System.currentTimeMillis();
        for (BlockProtection blockProtection : protections) {
            World world = this.plugin.getServer().getWorld(blockProtection.getWorld());
            if (world == null) continue;
            String worldName = world.getName();
            worlds.put(worldName, world);
            int x = blockProtection.getX() >> 4;
            int z = blockProtection.getZ() >> 4;
            ChunkPos chunkPos = new ChunkPos(worldName, x, z);
            blockProtectionsByChunk.computeIfAbsent(chunkPos, ignored -> new ArrayList());
            ((List)blockProtectionsByChunk.get(chunkPos)).add(blockProtection);
        }
        AtomicLong removed = new AtomicLong();
        CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : blockProtectionsByChunk.entrySet()) {
                ChunkPos chunkPos = (ChunkPos)entry.getKey();
                List blockProtections = (List)entry.getValue();
                try {
                    WORKING.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                World world = (World)worlds.get(chunkPos.world());
                int x = chunkPos.x();
                int z = chunkPos.z();
                ((CompletableFuture)world.getChunkAtAsync(x, z).thenAccept(ignored -> {
                    for (BlockProtection blockProtection : blockProtections) {
                        Block block = world.getBlockAt(blockProtection.getX(), blockProtection.getY(), blockProtection.getZ());
                        if (blockProtection.getBlock().equals(block.getType().name())) continue;
                        store.removeBlockProtection(blockProtection);
                        removed.incrementAndGet();
                        SchedulerUtil.schedule((Plugin)this.plugin, sender, () -> BoltComponents.sendMessage(sender, "cleanup_remove", new TagResolver[]{Placeholder.component((String)"raw_protection", (ComponentLike)Protections.raw(blockProtection))}));
                    }
                })).thenRun(WORKING::release);
            }
            WORKING.acquireUninterruptibly(10);
        }).thenRunAsync(() -> {
            long finish = System.currentTimeMillis();
            long seconds = (finish - start) / 1000L;
            BoltComponents.sendMessage(sender, "cleanup_complete", new TagResolver[]{Placeholder.component((String)"count", (ComponentLike)Component.text((long)removed.get())), Placeholder.component((String)"seconds", (ComponentLike)Component.text((long)seconds))});
            WORKING.release(10);
        }, SchedulerUtil.executor((Plugin)this.plugin, sender));
    }

    @Override
    public List<String> suggestions(CommandSender sender, Arguments arguments) {
        return Collections.emptyList();
    }

    @Override
    public void shortHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_short_admin_cleanup", new TagResolver[]{Placeholder.component((String)"command", (ComponentLike)Component.text((String)"/bolt admin cleanup"))});
    }

    @Override
    public void longHelp(CommandSender sender, Arguments arguments) {
        BoltComponents.sendMessage(sender, "help_command_long_admin_cleanup", new TagResolver[0]);
    }
}

