/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.command.callback;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.popcraft.bolt.BoltPlugin;
import org.popcraft.bolt.command.callback.Callback;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.SchedulerUtil;

public class CallbackManager {
    private static final Duration DEFAULT_EXPIRY = Duration.of(10L, ChronoUnit.MINUTES);
    private final Map<UUID, Callback> callbacks = new ConcurrentHashMap<UUID, Callback>();

    public CallbackManager(BoltPlugin plugin) {
        SchedulerUtil.schedule((Plugin)plugin, this::cleanupExpired, DEFAULT_EXPIRY.getSeconds() * 20L, DEFAULT_EXPIRY.getSeconds() * 20L);
    }

    private void cleanupExpired() {
        this.callbacks.entrySet().removeIf(i -> ((Callback)i.getValue()).expired());
    }

    public void execute(CommandSender sender, UUID id) {
        Callback callback = this.callbacks.get(id);
        if (callback == null) {
            BoltComponents.sendMessage(sender, "callback_expired", new TagResolver[0]);
        } else {
            callback.execute(sender);
        }
    }

    public ClickEvent register(Consumer<CommandSender> callback) {
        UUID uuid = UUID.randomUUID();
        this.callbacks.put(uuid, new Callback(Instant.now().plus(DEFAULT_EXPIRY), callback));
        return ClickEvent.runCommand((String)("/bolt callback " + String.valueOf(uuid)));
    }

    public ClickEvent registerPlayerOnly(Consumer<Player> callback) {
        return this.register(sender -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                callback.accept(player);
            } else {
                BoltComponents.sendMessage(sender, "command_player_only", new TagResolver[0]);
            }
        });
    }
}

