/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.popcraft.bolt.access.Access;

public class AccessRegistry {
    private final Map<String, Access> protections = new HashMap<String, Access>();
    private final Map<String, Access> access = new HashMap<String, Access>();

    public void registerProtectionType(String type, boolean restricted, Set<String> permissions) {
        this.protections.put(type, new Access(type, restricted, permissions));
    }

    public void registerAccessType(String type, boolean restricted, Set<String> permissions) {
        this.access.put(type, new Access(type, restricted, permissions));
    }

    public void unregisterAll() {
        this.protections.clear();
        this.access.clear();
    }

    public Optional<Access> getProtectionByType(String type) {
        return Optional.ofNullable(this.protections.get(type));
    }

    public Optional<Access> getAccessByType(String type) {
        return Optional.ofNullable(this.access.get(type));
    }

    public List<String> protectionTypes() {
        return this.protections.keySet().stream().toList();
    }

    public List<String> accessTypes() {
        return this.access.keySet().stream().toList();
    }

    public Collection<Access> protections() {
        return new ArrayList<Access>(this.protections.values());
    }

    public Collection<Access> access() {
        return new ArrayList<Access>(this.access.values());
    }

    public Optional<String> findProtectionTypeWithExactPermissions(Set<String> permissions) {
        return this.protections.values().stream().filter(a -> permissions.containsAll(a.permissions()) && a.permissions().containsAll(permissions)).map(Access::type).findFirst();
    }

    public Optional<String> findAccessTypeWithExactPermissions(Set<String> permissions) {
        return this.access.values().stream().filter(a -> permissions.containsAll(a.permissions()) && a.permissions().containsAll(permissions)).map(Access::type).findFirst();
    }
}

