/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.popcraft.bolt.Bolt;
import org.popcraft.bolt.BoltAPI;
import org.popcraft.bolt.access.Access;
import org.popcraft.bolt.access.AccessList;
import org.popcraft.bolt.access.AccessRegistry;
import org.popcraft.bolt.access.DefaultAccess;
import org.popcraft.bolt.command.Arguments;
import org.popcraft.bolt.command.BoltCommand;
import org.popcraft.bolt.command.callback.CallbackManager;
import org.popcraft.bolt.command.impl.AdminCommand;
import org.popcraft.bolt.command.impl.CallbackCommand;
import org.popcraft.bolt.command.impl.EditCommand;
import org.popcraft.bolt.command.impl.GroupCommand;
import org.popcraft.bolt.command.impl.HelpCommand;
import org.popcraft.bolt.command.impl.InfoCommand;
import org.popcraft.bolt.command.impl.LockCommand;
import org.popcraft.bolt.command.impl.ModeCommand;
import org.popcraft.bolt.command.impl.ModifyCommand;
import org.popcraft.bolt.command.impl.PasswordCommand;
import org.popcraft.bolt.command.impl.TransferCommand;
import org.popcraft.bolt.command.impl.TrustCommand;
import org.popcraft.bolt.command.impl.UnlockCommand;
import org.popcraft.bolt.data.ProfileCache;
import org.popcraft.bolt.data.SQLStore;
import org.popcraft.bolt.data.SimpleProfileCache;
import org.popcraft.bolt.data.SimpleProtectionCache;
import org.popcraft.bolt.data.migration.lwc.ConfigMigration;
import org.popcraft.bolt.data.migration.lwc.TrustMigration;
import org.popcraft.bolt.event.Event;
import org.popcraft.bolt.lang.Translator;
import org.popcraft.bolt.lib.net.kyori.event.EventBus;
import org.popcraft.bolt.lib.net.kyori.event.SimpleEventBus;
import org.popcraft.bolt.lib.org.bstats.bukkit.Metrics;
import org.popcraft.bolt.lib.org.bstats.charts.AdvancedPie;
import org.popcraft.bolt.lib.org.bstats.charts.DrilldownPie;
import org.popcraft.bolt.lib.org.bstats.charts.SimplePie;
import org.popcraft.bolt.listeners.BlockListener;
import org.popcraft.bolt.listeners.EntityListener;
import org.popcraft.bolt.listeners.InventoryListener;
import org.popcraft.bolt.listeners.PlayerListener;
import org.popcraft.bolt.listeners.adapter.ItemTransportingEntityValidateTargetEventListener;
import org.popcraft.bolt.matcher.Match;
import org.popcraft.bolt.matcher.block.AmethystClusterMatcher;
import org.popcraft.bolt.matcher.block.BannerMatcher;
import org.popcraft.bolt.matcher.block.BedMatcher;
import org.popcraft.bolt.matcher.block.BellMatcher;
import org.popcraft.bolt.matcher.block.BigDripleafMatcher;
import org.popcraft.bolt.matcher.block.BlockMatcher;
import org.popcraft.bolt.matcher.block.CakeMatcher;
import org.popcraft.bolt.matcher.block.CarpetMatcher;
import org.popcraft.bolt.matcher.block.ChestMatcher;
import org.popcraft.bolt.matcher.block.ChorusMatcher;
import org.popcraft.bolt.matcher.block.CocoaMatcher;
import org.popcraft.bolt.matcher.block.CoralMatcher;
import org.popcraft.bolt.matcher.block.CropsMatcher;
import org.popcraft.bolt.matcher.block.DeadBushMatcher;
import org.popcraft.bolt.matcher.block.DoorMatcher;
import org.popcraft.bolt.matcher.block.FarmlandMatcher;
import org.popcraft.bolt.matcher.block.FireMatcher;
import org.popcraft.bolt.matcher.block.FrogspawnMatcher;
import org.popcraft.bolt.matcher.block.GrassMatcher;
import org.popcraft.bolt.matcher.block.HangingRootsMatcher;
import org.popcraft.bolt.matcher.block.HangingSignMatcher;
import org.popcraft.bolt.matcher.block.HangingVineMatcher;
import org.popcraft.bolt.matcher.block.ItemFrameMatcher;
import org.popcraft.bolt.matcher.block.LadderMatcher;
import org.popcraft.bolt.matcher.block.LanternMatcher;
import org.popcraft.bolt.matcher.block.LeashKnotMatcher;
import org.popcraft.bolt.matcher.block.LilyPadMatcher;
import org.popcraft.bolt.matcher.block.MangrovePropaguleMatcher;
import org.popcraft.bolt.matcher.block.MossCarpetMatcher;
import org.popcraft.bolt.matcher.block.MultipleFacingMatcher;
import org.popcraft.bolt.matcher.block.MushroomMatcher;
import org.popcraft.bolt.matcher.block.NetherWartMatcher;
import org.popcraft.bolt.matcher.block.PaintingMatcher;
import org.popcraft.bolt.matcher.block.PinkPetalsMatcher;
import org.popcraft.bolt.matcher.block.PointedDripstoneMatcher;
import org.popcraft.bolt.matcher.block.PortalMatcher;
import org.popcraft.bolt.matcher.block.PressurePlateMatcher;
import org.popcraft.bolt.matcher.block.RailMatcher;
import org.popcraft.bolt.matcher.block.RedstoneWireMatcher;
import org.popcraft.bolt.matcher.block.RepeaterMatcher;
import org.popcraft.bolt.matcher.block.SaplingMatcher;
import org.popcraft.bolt.matcher.block.ScaffoldingMatcher;
import org.popcraft.bolt.matcher.block.SeaPickleMatcher;
import org.popcraft.bolt.matcher.block.SignMatcher;
import org.popcraft.bolt.matcher.block.SmallDripleafMatcher;
import org.popcraft.bolt.matcher.block.SmallFlowerMatcher;
import org.popcraft.bolt.matcher.block.SnowMatcher;
import org.popcraft.bolt.matcher.block.SoulFireMatcher;
import org.popcraft.bolt.matcher.block.SporeBlossomMatcher;
import org.popcraft.bolt.matcher.block.SweetBerryBushMatcher;
import org.popcraft.bolt.matcher.block.SwitchMatcher;
import org.popcraft.bolt.matcher.block.TallFlowerMatcher;
import org.popcraft.bolt.matcher.block.TallGrassMatcher;
import org.popcraft.bolt.matcher.block.TechnicalPistonMatcher;
import org.popcraft.bolt.matcher.block.TorchMatcher;
import org.popcraft.bolt.matcher.block.TripwireHookMatcher;
import org.popcraft.bolt.matcher.block.UprootMatcher;
import org.popcraft.bolt.matcher.block.VineMatcher;
import org.popcraft.bolt.matcher.entity.EntityMatcher;
import org.popcraft.bolt.protection.BlockProtection;
import org.popcraft.bolt.protection.EntityProtection;
import org.popcraft.bolt.protection.Protection;
import org.popcraft.bolt.source.GroupSourceTransformer;
import org.popcraft.bolt.source.PasswordSourceTransformer;
import org.popcraft.bolt.source.PlayerSourceResolver;
import org.popcraft.bolt.source.PlayerSourceTransformer;
import org.popcraft.bolt.source.Source;
import org.popcraft.bolt.source.SourceResolver;
import org.popcraft.bolt.source.SourceTransformer;
import org.popcraft.bolt.source.SourceTypeRegistry;
import org.popcraft.bolt.util.BlockLocation;
import org.popcraft.bolt.util.BoltComponents;
import org.popcraft.bolt.util.BoltPlayer;
import org.popcraft.bolt.util.BukkitPlayerResolver;
import org.popcraft.bolt.util.EnumUtil;
import org.popcraft.bolt.util.Group;
import org.popcraft.bolt.util.Mode;
import org.popcraft.bolt.util.ProtectableConfig;

public class BoltPlugin
extends JavaPlugin
implements BoltAPI {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("boltDebug", "false"));
    private static final String COMMAND_PERMISSION_KEY = "bolt.command.";
    private static final BlockMatcher CHEST_MATCHER = new ChestMatcher();
    private static final List<BlockMatcher> BLOCK_MATCHERS = List.of(CHEST_MATCHER, new BannerMatcher(), new BedMatcher(), new DoorMatcher(), new LeashKnotMatcher(), new PressurePlateMatcher(), new RailMatcher(), new SignMatcher(), new SwitchMatcher(), new CropsMatcher(), new FarmlandMatcher(), new UprootMatcher(), new BellMatcher(), new TorchMatcher(), new LanternMatcher(), new LadderMatcher(), new CocoaMatcher(), new TripwireHookMatcher(), new AmethystClusterMatcher(), new SaplingMatcher(), new TechnicalPistonMatcher(), new ItemFrameMatcher(), new PaintingMatcher(), new HangingVineMatcher(), new SeaPickleMatcher(), new VineMatcher(), new CakeMatcher(), new CoralMatcher(), new RedstoneWireMatcher(), new SmallFlowerMatcher(), new TallFlowerMatcher(), new SnowMatcher(), new CarpetMatcher(), new PortalMatcher(), new SmallDripleafMatcher(), new BigDripleafMatcher(), new ScaffoldingMatcher(), new MossCarpetMatcher(), new MushroomMatcher(), new NetherWartMatcher(), new SweetBerryBushMatcher(), new ChorusMatcher(), new GrassMatcher(), new TallGrassMatcher(), new DeadBushMatcher(), new HangingRootsMatcher(), new PointedDripstoneMatcher(), new FireMatcher(), new LilyPadMatcher(), new RepeaterMatcher(), new SporeBlossomMatcher(), new SoulFireMatcher(), new FrogspawnMatcher(), new MangrovePropaguleMatcher(), new MultipleFacingMatcher(), new HangingSignMatcher(), new PinkPetalsMatcher());
    private static final List<EntityMatcher> ENTITY_MATCHERS = List.of();
    private static final Source ADMIN_PERMISSION_SOURCE = Source.of("permission", "bolt.admin");
    private static final Source MOD_PERMISSION_SOURCE = Source.of("permission", "bolt.mod");
    private final List<BlockMatcher> enabledBlockMatchers = new ArrayList<BlockMatcher>();
    private final List<EntityMatcher> enabledEntityMatchers = new ArrayList<EntityMatcher>();
    private final Map<String, BoltCommand> commands = new HashMap<String, BoltCommand>();
    private final Path profileCachePath = this.getDataPath().resolve("profiles");
    private final ProfileCache profileCache = new SimpleProfileCache(this.profileCachePath);
    private final Map<Material, ProtectableConfig> protectableBlocks = new HashMap<Material, ProtectableConfig>();
    private final Map<EntityType, ProtectableConfig> protectableEntities = new HashMap<EntityType, ProtectableConfig>();
    private final Map<Material, Tag<Material>> materialTags = new HashMap<Material, Tag<Material>>();
    private final Set<Mode> defaultModes = new HashSet<Mode>();
    private String defaultProtectionType = "private";
    private String defaultAccessType = "normal";
    private Map<String, SourceTransformer> sourceTransformers = new HashMap<String, SourceTransformer>();
    private boolean useActionBar;
    private boolean doors;
    private boolean doorsOpenIron;
    private boolean doorsOpenDouble;
    private int doorsCloseAfter;
    private boolean doorsFixPlugins;
    private Bolt bolt;
    private CallbackManager callbackManager;
    private EventBus<Event> eventBus;

    public void onEnable() {
        this.saveDefaultConfig();
        SQLStore.Configuration databaseConfiguration = new SQLStore.Configuration(this.getConfig().getString("database.type", "sqlite").toLowerCase(), this.getConfig().getString("database.path", "%s/Bolt/bolt.db".formatted(this.getPluginsPath().toFile().getName())), this.getConfig().getString("database.hostname", ""), this.getConfig().getString("database.database", ""), this.getConfig().getString("database.username", ""), this.getConfig().getString("database.password", ""), this.getConfig().getString("database.prefix", ""), Optional.ofNullable(this.getConfig().getConfigurationSection("database.properties")).map(section -> section.getKeys(false)).stream().collect(Collectors.toMap(String::valueOf, key -> this.getConfig().getString("database.properties." + String.valueOf(key), ""))));
        this.bolt = new Bolt(new SimpleProtectionCache(new SQLStore(databaseConfiguration)));
        this.reload();
        BoltComponents.enable();
        this.registerEvents();
        this.registerCommands();
        this.callbackManager = new CallbackManager(this);
        this.eventBus = new SimpleEventBus<Event>(Event.class);
        this.profileCache.load();
        Metrics metrics = new Metrics(this, 17711);
        this.registerCustomCharts(metrics, databaseConfiguration);
        new ConfigMigration(this).convert();
        new TrustMigration(this).convert();
        this.getServer().getServicesManager().register(BoltAPI.class, (Object)this, (Plugin)this, ServicePriority.Normal);
    }

    public void onDisable() {
        BoltComponents.disable();
        HandlerList.unregisterAll((Plugin)this);
        this.commands.clear();
        this.getLogger().info(() -> "Flushing protection updates (%d)".formatted(this.bolt.getStore().pendingSave()));
        this.bolt.getStore().flush().join();
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
    }

    public void reload() {
        this.reloadConfig();
        Translator.loadAllTranslations(this.getDataPath(), this.getConfig().getString("language", "en"), this.getConfig().getBoolean("settings.per-player-locale", true));
        this.useActionBar = this.getConfig().getBoolean("settings.use-action-bar", false);
        this.doors = this.getConfig().getConfigurationSection("doors") != null;
        this.doorsOpenIron = this.getConfig().getBoolean("doors.open-iron", false);
        this.doorsOpenDouble = this.getConfig().getBoolean("doors.open-double", false);
        this.doorsCloseAfter = this.getConfig().getInt("doors.close-after", 0);
        this.doorsFixPlugins = this.getConfig().getBoolean("doors.fix-plugins", false);
        this.registerAccessTypes();
        this.registerProtectableAccess();
        this.nagInvalidHopperConfig();
        this.registerAccessSources();
        this.initializeMatchers();
        this.loadDefaultModes();
        this.registerDefaultSourceTransformers();
    }

    private void registerCustomCharts(Metrics metrics, SQLStore.Configuration databaseConfiguration) {
        metrics.addCustomChart(new SimplePie("config_language", Translator::selected));
        metrics.addCustomChart(new SimplePie("config_database", databaseConfiguration::type));
        metrics.addCustomChart(new AdvancedPie("config_protections", () -> {
            HashMap map = new HashMap();
            this.bolt.getAccessRegistry().protectionTypes().forEach(type -> map.put(type, 1));
            return map;
        }));
        metrics.addCustomChart(new AdvancedPie("config_access", () -> {
            HashMap map = new HashMap();
            this.bolt.getAccessRegistry().accessTypes().forEach(type -> map.put(type, 1));
            return map;
        }));
        metrics.addCustomChart(new DrilldownPie("config_blocks", () -> {
            HashMap map = new HashMap();
            Optional.ofNullable(this.getConfig().getConfigurationSection("blocks")).ifPresent(section -> {
                Set types = section.getKeys(false);
                types.forEach(type -> map.put(type, Map.of(section.getString("%s.autoProtect".formatted(type), "false"), 1)));
            });
            return map;
        }));
        metrics.addCustomChart(new DrilldownPie("config_entities", () -> {
            HashMap map = new HashMap();
            Optional.ofNullable(this.getConfig().getConfigurationSection("entities")).ifPresent(section -> {
                Set types = section.getKeys(false);
                types.forEach(type -> map.put(type, Map.of(section.getString("%s.autoProtect".formatted(type), "false"), 1)));
            });
            return map;
        }));
        metrics.addCustomChart(new SimplePie("protections_blocks", () -> String.valueOf((int)Math.ceil((float)this.bolt.getStore().loadBlockProtections().join().size() / 1000.0f) * 1000)));
        metrics.addCustomChart(new SimplePie("protections_entities", () -> String.valueOf((int)Math.ceil((float)this.bolt.getStore().loadEntityProtections().join().size() / 1000.0f) * 1000)));
    }

    private void registerAccessTypes() {
        ConfigurationSection access;
        this.bolt.getAccessRegistry().unregisterAll();
        ConfigurationSection protections = this.getConfig().getConfigurationSection("protections");
        if (protections != null) {
            for (String typeKey : protections.getKeys(false)) {
                String type = typeKey.toLowerCase();
                boolean requirePermission = protections.getBoolean("%s.require-permission".formatted(type), false);
                List allows = protections.getStringList("%s.allows".formatted(type));
                List permissions = allows.isEmpty() ? protections.getStringList(type) : allows;
                this.bolt.getAccessRegistry().registerProtectionType(type, requirePermission, new HashSet<String>(permissions));
                boolean isDefault = protections.getBoolean("%s.default".formatted(type), false);
                if (!isDefault) continue;
                this.defaultProtectionType = type;
            }
        }
        if ((access = this.getConfig().getConfigurationSection("access")) != null) {
            for (String typeKey : access.getKeys(false)) {
                String type = typeKey.toLowerCase();
                boolean requirePermission = access.getBoolean("%s.require-permission".formatted(type), false);
                List allows = access.getStringList("%s.allows".formatted(type));
                List permissions = allows.isEmpty() ? access.getStringList(type) : allows;
                this.bolt.getAccessRegistry().registerAccessType(type, requirePermission, new HashSet<String>(permissions));
                boolean isDefault = access.getBoolean("%s.default".formatted(type), false);
                if (!isDefault) continue;
                this.defaultAccessType = type;
            }
        }
    }

    private void registerProtectableAccess() {
        ConfigurationSection entities;
        ConfigurationSection blocks;
        this.protectableBlocks.clear();
        this.protectableEntities.clear();
        if (DEBUG) {
            for (Material material : Registry.MATERIAL) {
                if (!material.isBlock()) continue;
                this.protectableBlocks.put(material, new ProtectableConfig(this.bolt.getAccessRegistry().getProtectionByType(this.defaultAccessType).orElse(null), false, false));
            }
            for (EntityType entity2 : EntityType.values()) {
                this.protectableEntities.put(entity2, new ProtectableConfig(this.bolt.getAccessRegistry().getProtectionByType(this.defaultAccessType).orElse(null), false, false));
            }
        }
        if ((blocks = this.getConfig().getConfigurationSection("blocks")) != null) {
            for (String key : blocks.getKeys(false)) {
                String autoProtectType = blocks.getString("%s.autoProtect".formatted(key), "false");
                Access defaultAccess = this.bolt.getAccessRegistry().getProtectionByType(autoProtectType).orElse(null);
                boolean lockPermission = blocks.getBoolean("%s.lockPermission".formatted(key), false);
                boolean autoProtectPermission = blocks.getBoolean("%s.autoProtectPermission".formatted(key), false);
                if (key.startsWith("#")) {
                    Tag<Material> tag = this.resolveTagProtectableAccess("blocks", Material.class, key.substring(1));
                    if (tag == null) {
                        this.getLogger().warning(() -> "Invalid block tag defined in config: %s. Skipping.".formatted(key));
                        continue;
                    }
                    tag.getValues().forEach(block -> {
                        this.protectableBlocks.put((Material)block, new ProtectableConfig(defaultAccess, lockPermission, autoProtectPermission));
                        this.materialTags.put((Material)block, tag);
                    });
                    continue;
                }
                EnumUtil.valueOf(Material.class, key.toUpperCase()).filter(Material::isBlock).ifPresentOrElse(block -> this.protectableBlocks.put((Material)block, new ProtectableConfig(defaultAccess, lockPermission, autoProtectPermission)), () -> this.getLogger().warning(() -> "Invalid block defined in config: %s. Skipping.".formatted(key)));
            }
        }
        if ((entities = this.getConfig().getConfigurationSection("entities")) != null) {
            for (String key : entities.getKeys(false)) {
                String autoProtectType = entities.getString("%s.autoProtect".formatted(key), "false");
                Access defaultAccess = this.bolt.getAccessRegistry().getProtectionByType(autoProtectType).orElse(null);
                boolean lockPermission = entities.getBoolean("%s.lockPermission".formatted(key), false);
                boolean autoProtectPermission = entities.getBoolean("%s.autoProtectPermission".formatted(key), false);
                if (key.startsWith("#")) {
                    Tag<EntityType> tag = this.resolveTagProtectableAccess("entity_types", EntityType.class, key.substring(1));
                    if (tag == null) {
                        this.getLogger().warning(() -> "Invalid entity tag defined in config: %s. Skipping.".formatted(key));
                        continue;
                    }
                    tag.getValues().forEach(entity -> this.protectableEntities.put((EntityType)entity, new ProtectableConfig(defaultAccess, lockPermission, autoProtectPermission)));
                    continue;
                }
                EnumUtil.valueOf(EntityType.class, key.toUpperCase()).ifPresentOrElse(entity -> this.protectableEntities.put((EntityType)entity, new ProtectableConfig(defaultAccess, lockPermission, autoProtectPermission)), () -> this.getLogger().warning(() -> "Invalid entity defined in config: %s. Skipping.".formatted(key)));
            }
        }
    }

    private void nagInvalidHopperConfig() {
        if (this.getConfig().getBoolean("settings.ignore-hopper-nag", false) || !this.protectableBlocks.containsKey(Material.HOPPER)) {
            return;
        }
        File paperWorldDefaultsFile = Path.of(".", new String[0]).resolve("config/paper-world-defaults.yml").toFile();
        YamlConfiguration paperWorldDefaults = YamlConfiguration.loadConfiguration((File)paperWorldDefaultsFile);
        if (paperWorldDefaults.getBoolean("hopper.disable-move-event", false)) {
            this.getLogger().warning(() -> "The server's Paper config has disable-move-event enabled. As a result, Hopper protections will not function properly. To resolve this issue, please either disable this in the Paper config, or remove hoppers from the blocks list in your Bolt config if you do not want hoppers protected.");
        }
    }

    private void registerAccessSources() {
        SourceTypeRegistry sourceTypeRegistry = this.bolt.getSourceTypeRegistry();
        sourceTypeRegistry.unregisterAll();
        ConfigurationSection sources = this.getConfig().getConfigurationSection("sources");
        if (sources == null) {
            return;
        }
        for (String source : sources.getKeys(false)) {
            boolean requirePermission = sources.getBoolean("%s.require-permission".formatted(source), false);
            boolean unique = sources.getBoolean("%s.unique".formatted(source), false);
            sourceTypeRegistry.registerSourceType(source, requirePermission, unique);
        }
        if (sourceTypeRegistry.sourceTypes().isEmpty()) {
            sourceTypeRegistry.registerSourceType("player", false, false);
            sourceTypeRegistry.registerSourceType("password", false, false);
            sourceTypeRegistry.registerSourceType("group", false, false);
            sourceTypeRegistry.registerSourceType("permission", true, false);
        }
    }

    private <T extends Keyed> Tag<T> resolveTagProtectableAccess(String registry, Class<T> clazz, String name) {
        NamespacedKey tagKey = NamespacedKey.fromString((String)name);
        return tagKey == null ? null : this.getServer().getTag(registry, tagKey, clazz);
    }

    private void loadDefaultModes() {
        this.defaultModes.clear();
        List modes = this.getConfig().getStringList("settings.default-modes");
        for (String modeName : modes) {
            Mode mode;
            try {
                mode = Mode.valueOf(modeName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning(() -> "Invalid default mode defined in config: %s. Skipping.".formatted(modeName));
                return;
            }
            this.defaultModes.add(mode);
        }
    }

    public Set<Mode> defaultModes() {
        return this.defaultModes;
    }

    private void initializeMatchers() {
        this.enabledBlockMatchers.clear();
        this.enabledEntityMatchers.clear();
        BLOCK_MATCHERS.forEach(blockMatcher -> blockMatcher.initialize(this.protectableBlocks.keySet(), this.protectableEntities.keySet()));
        ENTITY_MATCHERS.forEach(entityMatcher -> entityMatcher.initialize(this.protectableBlocks.keySet(), this.protectableEntities.keySet()));
        for (BlockMatcher blockMatcher2 : BLOCK_MATCHERS) {
            if (!blockMatcher2.enabled()) continue;
            this.enabledBlockMatchers.add(blockMatcher2);
        }
        for (EntityMatcher entityMatcher2 : ENTITY_MATCHERS) {
            if (!entityMatcher2.enabled()) continue;
            this.enabledEntityMatchers.add(entityMatcher2);
        }
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new BlockListener(this), (Plugin)this);
        EntityListener entityListener = new EntityListener(this);
        pluginManager.registerEvents((Listener)entityListener, (Plugin)this);
        if (ItemTransportingEntityValidateTargetEventListener.canUse()) {
            pluginManager.registerEvents((Listener)new ItemTransportingEntityValidateTargetEventListener(entityListener::onItemTransportingEntityValidateTarget), (Plugin)this);
        }
        pluginManager.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
    }

    private void registerCommands() {
        this.commands.put("admin", new AdminCommand(this));
        this.commands.put("edit", new EditCommand(this));
        this.commands.put("group", new GroupCommand(this));
        this.commands.put("help", new HelpCommand(this));
        this.commands.put("info", new InfoCommand(this));
        this.commands.put("lock", new LockCommand(this));
        this.commands.put("mode", new ModeCommand(this));
        this.commands.put("modify", new ModifyCommand(this));
        this.commands.put("password", new PasswordCommand(this));
        this.commands.put("transfer", new TransferCommand(this));
        this.commands.put("trust", new TrustCommand(this));
        this.commands.put("unlock", new UnlockCommand(this));
        this.commands.put("callback", new CallbackCommand(this));
    }

    public Map<String, BoltCommand> commands() {
        return this.commands;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        int commandStart;
        boolean isBoltCommand = "bolt".equalsIgnoreCase(command.getName());
        int n = commandStart = isBoltCommand ? 1 : 0;
        if (args.length < commandStart) {
            this.commands.get("help").execute(sender, new Arguments(new String[0]));
            return true;
        }
        String commandKey = (isBoltCommand ? args[0] : command.getName()).toLowerCase();
        if (!this.commands.containsKey(commandKey)) {
            BoltComponents.sendMessage(sender, "command_invalid", new TagResolver[0]);
            return true;
        }
        if (!sender.hasPermission(COMMAND_PERMISSION_KEY + commandKey)) {
            BoltComponents.sendMessage(sender, "command_no_permission", new TagResolver[0]);
            return true;
        }
        this.commands.get(commandKey).execute(sender, new Arguments(Arrays.copyOfRange(args, commandStart, args.length)));
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        boolean isBoltCommand = "bolt".equalsIgnoreCase(command.getName());
        int commandStart = isBoltCommand ? 1 : 0;
        String commandKey = (isBoltCommand ? args[0] : command.getName()).toLowerCase();
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == commandStart) {
            this.commands.entrySet().stream().filter(i -> sender.hasPermission(COMMAND_PERMISSION_KEY + (String)i.getKey()) && !((BoltCommand)i.getValue()).hidden()).forEach(i -> suggestions.add((String)i.getKey()));
        } else if (this.commands.containsKey(commandKey) && sender.hasPermission(COMMAND_PERMISSION_KEY + commandKey)) {
            suggestions.addAll(this.commands.get(commandKey).suggestions(sender, new Arguments(Arrays.copyOfRange(args, commandStart, args.length))));
        }
        return suggestions.stream().filter(s -> s.toLowerCase().contains(args[args.length - 1].toLowerCase())).toList();
    }

    public Bolt getBolt() {
        return this.bolt;
    }

    public Path getDataPath() {
        return this.getDataFolder().toPath();
    }

    public Path getPluginsPath() {
        return this.getDataPath().getParent();
    }

    public boolean isUseActionBar() {
        return this.useActionBar;
    }

    public boolean isDoors() {
        return this.doors;
    }

    public boolean isDoorsOpenIron() {
        return this.doorsOpenIron;
    }

    public boolean isDoorsOpenDouble() {
        return this.doorsOpenDouble;
    }

    public int getDoorsCloseAfter() {
        return this.doorsCloseAfter;
    }

    public boolean getDoorsFixPlugins() {
        return this.doorsFixPlugins;
    }

    public ProfileCache getProfileCache() {
        return this.profileCache;
    }

    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public EventBus<Event> getEventBus() {
        return this.eventBus;
    }

    @Override
    public <T extends Event> void registerListener(Class<T> clazz, Consumer<? super T> listener) {
        this.eventBus.register(clazz, listener::accept);
    }

    public BoltPlayer player(Player player) {
        return this.player(player.getUniqueId());
    }

    public BoltPlayer player(UUID uuid) {
        return this.bolt.getBoltPlayer(uuid);
    }

    public List<String> getPlayersOwnedGroups(Player player) {
        return this.bolt.getStore().loadGroups().join().stream().filter(group -> group.getOwner().equals(player.getUniqueId())).map(Group::getName).toList();
    }

    public ProtectableConfig getProtectableConfig(Block block) {
        return this.protectableBlocks.get(block.getType());
    }

    public ProtectableConfig getProtectableConfig(Entity entity) {
        return this.protectableEntities.get(entity.getType());
    }

    public String getDefaultProtectionType() {
        return this.defaultProtectionType;
    }

    public String getDefaultAccessType() {
        return this.defaultAccessType;
    }

    public BlockMatcher getChestMatcher() {
        return CHEST_MATCHER;
    }

    public Map<Material, Tag<Material>> getMaterialTags() {
        return this.materialTags;
    }

    @Override
    public boolean isProtectable(Block block) {
        return DEBUG || this.protectableBlocks.containsKey(block.getType());
    }

    public boolean isProtectable(Material material) {
        return DEBUG || this.protectableBlocks.containsKey(material);
    }

    @Override
    public boolean isProtectable(Entity entity) {
        return DEBUG || this.protectableEntities.containsKey(entity.getType());
    }

    @Override
    public boolean isProtected(Block block) {
        return this.findProtection(block) != null;
    }

    @Override
    public boolean isProtected(Entity entity) {
        return this.findProtection(entity) != null;
    }

    @Override
    public boolean isProtectedExact(Block block) {
        return this.loadProtection(block) != null;
    }

    @Override
    public boolean isProtectedExact(Entity entity) {
        return this.loadProtection(entity) != null;
    }

    @Override
    public BlockProtection createProtection(Block block, UUID owner, String type) {
        long now = System.currentTimeMillis();
        return new BlockProtection(UUID.randomUUID(), owner, type, now, now, new HashMap<String, String>(), block.getWorld().getName(), block.getX(), block.getY(), block.getZ(), block.getType().name());
    }

    @Override
    public EntityProtection createProtection(Entity entity, UUID owner, String type) {
        long now = System.currentTimeMillis();
        return new EntityProtection(entity.getUniqueId(), owner, type, now, now, new HashMap<String, String>(), entity.getType().name());
    }

    @Override
    public Collection<Protection> loadProtections() {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        protections.addAll(this.bolt.getStore().loadBlockProtections().join());
        protections.addAll(this.bolt.getStore().loadEntityProtections().join());
        return protections;
    }

    @Override
    public BlockProtection loadProtection(Block block) {
        BlockLocation blockLocation = new BlockLocation(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
        return this.bolt.getStore().loadBlockProtection(blockLocation).join();
    }

    @Override
    public EntityProtection loadProtection(Entity entity) {
        UUID uuid = entity.getUniqueId();
        return this.bolt.getStore().loadEntityProtection(uuid).join();
    }

    @Override
    public void saveProtection(Protection protection) {
        if (protection instanceof BlockProtection) {
            BlockProtection blockProtection = (BlockProtection)protection;
            this.bolt.getStore().saveBlockProtection(blockProtection);
        } else if (protection instanceof EntityProtection) {
            EntityProtection entityProtection = (EntityProtection)protection;
            this.bolt.getStore().saveEntityProtection(entityProtection);
        }
    }

    @Override
    public void removeProtection(Protection protection) {
        if (protection instanceof BlockProtection) {
            BlockProtection blockProtection = (BlockProtection)protection;
            this.bolt.getStore().removeBlockProtection(blockProtection);
        } else if (protection instanceof EntityProtection) {
            EntityProtection entityProtection = (EntityProtection)protection;
            this.bolt.getStore().removeEntityProtection(entityProtection);
        }
    }

    @Override
    public Protection findProtection(Block block) {
        BlockProtection protection = this.loadProtection(block);
        return protection != null ? protection : this.matchProtection(block);
    }

    @Override
    public Protection findProtection(Entity entity) {
        EntityProtection protection = this.loadProtection(entity);
        return protection != null ? protection : this.matchProtection(entity);
    }

    @Override
    public Collection<Protection> findProtections(World world, BoundingBox boundingBox) {
        ArrayList<Protection> protections = new ArrayList<Protection>();
        this.bolt.getStore().loadBlockProtections().join().stream().filter(p -> world.getName().equals(p.getWorld())).filter(p -> boundingBox.contains((double)p.getX(), (double)p.getY(), (double)p.getZ())).forEach(protections::add);
        Collection<EntityProtection> entityProtections = this.bolt.getStore().loadEntityProtections().join();
        for (EntityProtection entityProtection : entityProtections) {
            Entity entity = this.getServer().getEntity(entityProtection.getId());
            if (entity == null || !world.getName().equals(entity.getWorld().getName()) || !boundingBox.contains(entity.getBoundingBox())) continue;
            protections.add(entityProtection);
        }
        return protections;
    }

    @Override
    public boolean canAccess(Block block, Player player, String ... permissions) {
        return this.canAccess(this.findProtection(block), player.getUniqueId(), permissions);
    }

    @Override
    public boolean canAccess(Entity entity, Player player, String ... permissions) {
        return this.canAccess(this.findProtection(entity), player.getUniqueId(), permissions);
    }

    @Override
    public boolean canAccess(Protection protection, Player player, String ... permissions) {
        return this.canAccess(protection, player.getUniqueId(), permissions);
    }

    @Override
    public boolean canAccess(Protection protection, UUID uuid, String ... permissions) {
        return this.canAccess(protection, new BukkitPlayerResolver(this.bolt, uuid), permissions);
    }

    @Override
    public boolean canAccess(Protection protection, SourceResolver sourceResolver, String ... permissions) {
        if (protection == null || permissions.length == 0) {
            return true;
        }
        return permissions.length == 1 ? this.canAccessSingle(protection, sourceResolver, permissions[0]) : this.canAccessMulti(protection, sourceResolver, permissions);
    }

    private boolean canAccessMulti(Protection protection, SourceResolver sourceResolver, String ... permissions) {
        AccessRegistry accessRegistry;
        Access protectionType;
        HashSet<String> unresolved = new HashSet<String>(Arrays.asList(permissions));
        Source ownerSource = Source.player(protection.getOwner());
        if (sourceResolver.resolve(ownerSource) || sourceResolver.resolve(ADMIN_PERMISSION_SOURCE)) {
            unresolved.removeAll(DefaultAccess.OWNER);
            if (unresolved.isEmpty()) {
                return true;
            }
        }
        if (sourceResolver.resolve(MOD_PERMISSION_SOURCE)) {
            unresolved.removeAll(DefaultAccess.DISPLAY);
            if (unresolved.isEmpty()) {
                return true;
            }
        }
        if ((protectionType = (Access)(accessRegistry = this.bolt.getAccessRegistry()).getProtectionByType(protection.getType()).orElse(null)) != null) {
            unresolved.removeAll(protectionType.permissions());
            if (unresolved.isEmpty()) {
                return true;
            }
        }
        for (Map.Entry<String, String> entry : protection.getAccess().entrySet()) {
            Access accessType;
            if (!sourceResolver.resolve(Source.parse(entry.getKey())) || (accessType = (Access)accessRegistry.getAccessByType(entry.getValue()).orElse(null)) == null) continue;
            unresolved.removeAll(accessType.permissions());
            if (!unresolved.isEmpty()) continue;
            return true;
        }
        AccessList accessList = this.bolt.getStore().loadAccessList(protection.getOwner()).join();
        if (accessList != null) {
            for (Map.Entry<String, String> entry : accessList.getAccess().entrySet()) {
                Access accessType;
                if (!sourceResolver.resolve(Source.parse(entry.getKey())) || (accessType = (Access)accessRegistry.getAccessByType(entry.getValue()).orElse(null)) == null) continue;
                unresolved.removeAll(accessType.permissions());
                if (!unresolved.isEmpty()) continue;
                return true;
            }
        }
        unresolved.removeIf(permission -> sourceResolver.resolve(Source.of("permission", "bolt.permission." + permission)));
        return unresolved.isEmpty();
    }

    private boolean canAccessSingle(Protection protection, SourceResolver sourceResolver, String permission) {
        Source ownerSource = Source.player(protection.getOwner());
        if ((sourceResolver.resolve(ownerSource) || sourceResolver.resolve(ADMIN_PERMISSION_SOURCE)) && DefaultAccess.OWNER.contains(permission)) {
            return true;
        }
        if (sourceResolver.resolve(MOD_PERMISSION_SOURCE) && DefaultAccess.DISPLAY.contains(permission)) {
            return true;
        }
        AccessRegistry accessRegistry = this.bolt.getAccessRegistry();
        Access protectionType = accessRegistry.getProtectionByType(protection.getType()).orElse(null);
        if (protectionType != null && protectionType.permissions().contains(permission)) {
            return true;
        }
        for (Map.Entry<String, String> entry : protection.getAccess().entrySet()) {
            Access accessType;
            if (!sourceResolver.resolve(Source.parse(entry.getKey())) || (accessType = (Access)accessRegistry.getAccessByType(entry.getValue()).orElse(null)) == null || !accessType.permissions().contains(permission)) continue;
            return true;
        }
        AccessList accessList = this.bolt.getStore().loadAccessList(protection.getOwner()).join();
        if (accessList != null) {
            for (Map.Entry<String, String> entry : accessList.getAccess().entrySet()) {
                Access accessType;
                if (!sourceResolver.resolve(Source.parse(entry.getKey())) || (accessType = (Access)accessRegistry.getAccessByType(entry.getValue()).orElse(null)) == null || !accessType.permissions().contains(permission)) continue;
                return true;
            }
        }
        return sourceResolver.resolve(Source.of("permission", "bolt.permission." + permission));
    }

    @Override
    public void registerPlayerSourceResolver(PlayerSourceResolver playerSourceResolver) {
        this.bolt.getRegisteredPlayerResolvers().add(playerSourceResolver);
    }

    private Protection matchProtection(Block block) {
        for (BlockMatcher blockMatcher : this.enabledBlockMatchers) {
            Protection protection;
            Match match;
            if (!blockMatcher.canMatch(block) || (match = blockMatcher.findMatch(block)) == null) continue;
            for (Block matchBlock : match.blocks()) {
                protection = this.loadProtection(matchBlock);
                if (protection == null) continue;
                return protection;
            }
            for (Entity matchEntity : match.entities()) {
                protection = this.loadProtection(matchEntity);
                if (protection == null) continue;
                return protection;
            }
        }
        return null;
    }

    private Protection matchProtection(Entity entity) {
        for (EntityMatcher entityMatcher : this.enabledEntityMatchers) {
            Protection protection;
            Match match;
            if (!entityMatcher.canMatch(entity) || (match = entityMatcher.findMatch(entity)) == null) continue;
            for (Block matchBlock : match.blocks()) {
                protection = this.loadProtection(matchBlock);
                if (protection == null) continue;
                return protection;
            }
            for (Entity matchEntity : match.entities()) {
                protection = this.loadProtection(matchEntity);
                if (protection == null) continue;
                return protection;
            }
        }
        return null;
    }

    @Override
    public void registerSourceTransformer(String sourceType, SourceTransformer sourceTransformer) {
        this.sourceTransformers.put(sourceType, sourceTransformer);
    }

    private void registerDefaultSourceTransformers() {
        this.sourceTransformers.put("player", new PlayerSourceTransformer(this));
        this.sourceTransformers.put("password", new PasswordSourceTransformer());
        this.sourceTransformers.put("group", new GroupSourceTransformer(this));
    }

    public SourceTransformer getSourceTransformer(String type) {
        return this.sourceTransformers.getOrDefault(type, SourceTransformer.DEFAULT);
    }
}

