/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.bolt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.popcraft.bolt.access.AccessRegistry;
import org.popcraft.bolt.data.Store;
import org.popcraft.bolt.source.PlayerSourceResolver;
import org.popcraft.bolt.source.SourceTypeRegistry;
import org.popcraft.bolt.util.BoltPlayer;

public final class Bolt {
    private final AccessRegistry accessRegistry = new AccessRegistry();
    private final SourceTypeRegistry sourceTypeRegistry = new SourceTypeRegistry();
    private final Map<UUID, BoltPlayer> players = new HashMap<UUID, BoltPlayer>();
    private final List<PlayerSourceResolver> registeredPlayerResolvers = new ArrayList<PlayerSourceResolver>();
    private Store store;

    public Bolt(Store store) {
        this.store = store;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public BoltPlayer getBoltPlayer(UUID uuid) {
        return this.players.computeIfAbsent(uuid, x -> new BoltPlayer(uuid));
    }

    public void removeBoltPlayer(UUID uuid) {
        this.players.remove(uuid);
    }

    public AccessRegistry getAccessRegistry() {
        return this.accessRegistry;
    }

    public SourceTypeRegistry getSourceTypeRegistry() {
        return this.sourceTypeRegistry;
    }

    public List<PlayerSourceResolver> getRegisteredPlayerResolvers() {
        return this.registeredPlayerResolvers;
    }
}

