/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.misc.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;

public class LocationAdapter
implements JsonDeserializer<Location>,
JsonSerializer<Location> {
    public static final LocationAdapter INSTANCE = new LocationAdapter();

    public Location deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("not a JSON object");
        }
        JsonObject obj = (JsonObject)json;
        JsonElement world = obj.get("world");
        JsonElement x = obj.get("x");
        JsonElement y = obj.get("y");
        JsonElement z = obj.get("z");
        JsonElement yaw = obj.get("yaw");
        JsonElement pitch = obj.get("pitch");
        if (world == null || x == null || y == null || z == null || yaw == null || pitch == null) {
            throw new JsonParseException("Malformed location json string!");
        }
        if (!world.isJsonPrimitive() || !((JsonPrimitive)world).isString()) {
            throw new JsonParseException("world is not a string");
        }
        if (!x.isJsonPrimitive() || !((JsonPrimitive)x).isNumber()) {
            throw new JsonParseException("x is not a number");
        }
        if (!y.isJsonPrimitive() || !((JsonPrimitive)y).isNumber()) {
            throw new JsonParseException("y is not a number");
        }
        if (!z.isJsonPrimitive() || !((JsonPrimitive)z).isNumber()) {
            throw new JsonParseException("z is not a number");
        }
        if (!yaw.isJsonPrimitive() || !((JsonPrimitive)yaw).isNumber()) {
            throw new JsonParseException("yaw is not a number");
        }
        if (!pitch.isJsonPrimitive() || !((JsonPrimitive)pitch).isNumber()) {
            throw new JsonParseException("pitch is not a number");
        }
        World worldInstance = Bukkit.getWorld((String)world.getAsString());
        if (worldInstance == null && (worldInstance = Bukkit.createWorld((WorldCreator)new WorldCreator(world.getAsString()))) == null) {
            throw new IllegalArgumentException("Unknown/not loaded world");
        }
        return new Location(worldInstance, x.getAsDouble(), y.getAsDouble(), z.getAsDouble(), yaw.getAsFloat(), pitch.getAsFloat());
    }

    public JsonElement serialize(Location location, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        obj.addProperty("world", location.getWorld().getName());
        obj.addProperty("x", (Number)location.getX());
        obj.addProperty("y", (Number)location.getY());
        obj.addProperty("z", (Number)location.getZ());
        obj.addProperty("yaw", (Number)Float.valueOf(location.getYaw()));
        obj.addProperty("pitch", (Number)Float.valueOf(location.getPitch()));
        return obj;
    }
}

