/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.misc;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;

public class TranslationManager {
    public static Locale FALLBACK = Locale.US;
    private final HashMap<String, JsonObject> translations;
    private final MiniMessage miniMessage;
    public static TranslationManager INSTANCE = null;

    public TranslationManager() throws IOException {
        FALLBACK = QuakePlugin.INSTANCE.config.locale.getFallbackLocale();
        this.translations = new HashMap();
        this.miniMessage = MiniMessage.miniMessage();
        this.loadLocale(FALLBACK);
        INSTANCE = this;
    }

    private void loadLocale(Locale locale) throws IOException {
        String localeString = locale.toString();
        String filename = "lang_" + localeString + ".json";
        JsonObject localeData = null;
        File configFolder = QuakePlugin.INSTANCE.getDataFolder();
        File localeFile = new File(configFolder, filename);
        if (localeFile.exists()) {
            QuakePlugin.INSTANCE.getLogger().info("Loading locale " + localeString + " from config folder: " + localeFile.getPath());
            try (FileReader reader = new FileReader(localeFile);){
                localeData = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                QuakePlugin.INSTANCE.getLogger().warning("Failed to load locale from config folder: " + e.getMessage());
                QuakePlugin.INSTANCE.getLogger().warning("Falling back to JAR resource");
            }
        }
        if (localeData == null) {
            InputStream resourceStream = QuakePlugin.INSTANCE.getResource(filename);
            if (resourceStream != null) {
                QuakePlugin.INSTANCE.getLogger().info("Loading locale " + localeString + " from JAR resources");
                String jsonContent = new String(resourceStream.readAllBytes(), StandardCharsets.UTF_8);
                localeData = (JsonObject)new Gson().fromJson(jsonContent, JsonObject.class);
                resourceStream.close();
            } else {
                throw new IOException("Locale file not found: " + filename);
            }
        }
        this.translations.put(localeString, localeData);
        this.translations.put(locale.getLanguage(), localeData);
    }

    private String getTranslationString(String key, Locale locale) {
        JsonObject localeTranslations;
        String localeString = locale.toString();
        if (!this.translations.containsKey(localeString) && !this.translations.containsKey(locale.getLanguage())) {
            try {
                this.loadLocale(locale);
            }
            catch (IOException e) {
                QuakePlugin.INSTANCE.getLogger().warning("Failed to load locale " + localeString + ": " + e.getMessage());
            }
        }
        if ((localeTranslations = this.translations.get(localeString)) == null) {
            localeTranslations = this.translations.get(locale.getLanguage());
        }
        if (localeTranslations == null && (localeTranslations = this.translations.get(FALLBACK.toString())) == null) {
            localeTranslations = this.translations.get(FALLBACK.getLanguage());
        }
        String[] keyParts = key.split("\\.");
        JsonObject current = localeTranslations;
        for (String part : keyParts) {
            if (current == null || !current.isJsonObject()) break;
            current = current.getAsJsonObject().get(part);
        }
        if (current != null && current.isJsonPrimitive()) {
            return current.getAsString();
        }
        if (!localeString.equals(FALLBACK.toString()) && !locale.getLanguage().equals(FALLBACK.getLanguage())) {
            JsonObject fallbackTranslations = this.translations.get(FALLBACK.toString());
            if (fallbackTranslations == null) {
                fallbackTranslations = this.translations.get(FALLBACK.getLanguage());
            }
            if (fallbackTranslations != null) {
                current = fallbackTranslations;
                for (String part : keyParts) {
                    if (current == null || !current.isJsonObject()) break;
                    current = current.getAsJsonObject().get(part);
                }
                if (current != null && current.isJsonPrimitive()) {
                    QuakePlugin.INSTANCE.getLogger().warning("TranslationManager could not get translation of " + key + " for locale " + localeString + ", falling back to " + FALLBACK.toString());
                    return current.getAsString();
                }
            }
        }
        QuakePlugin.INSTANCE.getLogger().severe("TranslationManager could not get translation of " + key);
        return key;
    }

    public Component translate(String key, Locale locale, TagResolver ... placeholders) {
        String translatedString = this.getTranslationString(key, locale);
        if (placeholders.length > 0) {
            return this.miniMessage.deserialize(translatedString, placeholders);
        }
        return this.miniMessage.deserialize((Object)translatedString);
    }

    public Component translate(String key, Player player, TagResolver ... placeholders) {
        return this.translate(key, player.locale(), placeholders);
    }

    public String translateLegacy(String key, Locale locale) {
        return this.getTranslationString(key, locale);
    }

    public String translateLegacy(String key, Player player) {
        return this.getTranslationString(key, player.locale());
    }

    public static Component t(String key, Locale locale, TagResolver ... placeholders) {
        return INSTANCE.translate(key, locale, placeholders);
    }

    public static Component t(String key, Player player, TagResolver ... placeholders) {
        return INSTANCE.translate(key, player, placeholders);
    }

    public static String tLegacy(String key, Locale locale) {
        return INSTANCE.translateLegacy(key, locale);
    }

    public static String tLegacy(String key, Player player) {
        return INSTANCE.translateLegacy(key, player);
    }
}

