/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.misc;

import java.util.ArrayList;
import java.util.List;

public class TableBuilder {
    private List<String[]> rows = new ArrayList<String[]>();
    private int[] columnWidths;

    public TableBuilder addRow(String ... cells) {
        this.rows.add(cells);
        return this;
    }

    private int[] calculateColumnWidths() {
        int columnCount = 0;
        for (String[] row : this.rows) {
            columnCount = Math.max(columnCount, row.length);
        }
        int[] widths = new int[columnCount];
        for (String[] row : this.rows) {
            for (int i = 0; i < row.length; ++i) {
                widths[i] = Math.max(widths[i], row[i].length());
            }
        }
        return widths;
    }

    public String build() {
        StringBuilder table = new StringBuilder();
        this.columnWidths = this.calculateColumnWidths();
        for (int r = 0; r < this.rows.size(); ++r) {
            String[] row = this.rows.get(r);
            for (int i = 0; i < row.length; ++i) {
                table.append(row[i]);
                int spacesToAdd = this.columnWidths[i] - row[i].length();
                table.append(" ".repeat(Math.max(0, spacesToAdd)));
                if (i >= row.length - 1) continue;
                table.append(" ");
            }
            if (r >= this.rows.size() - 1) continue;
            table.append("\n");
        }
        return table.toString();
    }
}

