/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.misc;

import com.github.polyzium.quakechasm.misc.adapters.LocationAdapter;
import com.github.polyzium.quakechasm.misc.adapters.WorldAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public abstract class MiscUtil {
    public static final double GRAVITY = 0.08;
    public static final double AIR_DRAG = 0.91;

    public static void teleEffect(Location targetLoc, boolean teleOut) {
        World world = targetLoc.getWorld();
        if (!teleOut) {
            targetLoc.getWorld().playSound(targetLoc, "quake.world.tele_in", 1.0f, 1.0f);
        } else {
            targetLoc.getWorld().playSound(targetLoc, "quake.world.tele_out", 1.0f, 1.0f);
        }
        world.spawnParticle(Particle.DUST, targetLoc, 32, 0.25, 1.0, 0.25, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)0xFF00FF), 1.0f));
        world.spawnParticle(Particle.INSTANT_EFFECT, targetLoc, 32, 0.25, 1.0, 0.25, 1.0);
    }

    public static ArrayList<Vector> calculateTrajectory(Location startLoc, Vector initialVelocity) {
        ArrayList<Vector> trajectory = new ArrayList<Vector>(128);
        Vector pos = startLoc.toVector();
        World world = startLoc.getWorld();
        Vector velocity = initialVelocity.clone();
        velocity.setX(velocity.getX() * 0.6);
        velocity.setZ(velocity.getZ() * 0.6);
        trajectory.add(pos.clone());
        for (int i = 0; i < 127; ++i) {
            if (i == 3) {
                velocity = initialVelocity.clone();
            } else {
                velocity.setY(velocity.getY() - 0.08);
                velocity.setX(velocity.getX() * 0.91);
                velocity.setZ(velocity.getZ() * 0.91);
            }
            Vector nextPos = pos.clone().add(velocity);
            if (MiscUtil.raytraceHitsBlock(world, pos, nextPos)) break;
            pos.copy(nextPos);
            trajectory.add(pos.clone());
            if (world.getBlockAt(pos.toLocation(world)).getType() != Material.AIR) break;
        }
        return trajectory;
    }

    private static boolean raytraceHitsBlock(World world, Vector start, Vector end) {
        Vector direction = end.clone().subtract(start);
        double distance = direction.length();
        if (distance == 0.0) {
            return false;
        }
        direction.normalize();
        double step = 0.1;
        int steps = (int)Math.ceil(distance / step);
        for (int i = 0; i <= steps; ++i) {
            Vector checkPos = start.clone().add(direction.clone().multiply((double)i * step));
            Location checkLoc = checkPos.toLocation(world);
            if (world.getBlockAt(checkLoc).isPassable()) continue;
            return true;
        }
        return false;
    }

    public static String[] getEnumNames(Class<? extends Enum<?>> e) {
        return (String[])Arrays.stream(e.getEnumConstants()).map(Enum::name).toArray(String[]::new);
    }

    public static String[] getEnumNamesLowercase(Class<? extends Enum<?>> e) {
        return (String[])Arrays.stream(e.getEnumConstants()).map(Enum::name).map(String::toLowerCase).toArray(String[]::new);
    }

    public static Gson getEnhancedGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeHierarchyAdapter(World.class, (Object)new WorldAdapter());
        builder.registerTypeAdapter(Location.class, (Object)new LocationAdapter());
        return builder.create();
    }

    public static boolean chunkIntersectsBoundingBox(Chunk chunk, BoundingBox boundingBox) {
        int chunkMinX = chunk.getX() << 4;
        int chunkMinZ = chunk.getZ() << 4;
        int chunkMaxX = chunkMinX + 15;
        int chunkMaxZ = chunkMinZ + 15;
        BoundingBox chunkBB = new BoundingBox((double)chunkMinX, (double)chunk.getWorld().getMinHeight(), (double)chunkMinZ, (double)chunkMaxX, (double)chunk.getWorld().getMaxHeight(), (double)chunkMaxZ);
        return boundingBox.overlaps(chunkBB);
    }

    public static void setNameForItemStack(ItemStack itemStack, Component name) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.displayName(name);
        itemStack.setItemMeta(itemMeta);
    }
}

