/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.matchmaking.matches;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.map.QMap;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchPrivacy;
import com.github.polyzium.quakechasm.matchmaking.matches.QManageable;
import com.github.polyzium.quakechasm.misc.TableBuilder;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TDMMatch
extends Match {
    @QManageable(name="fraglimit", min=1, max=1000, description="Number of frags needed to win")
    private int fraglimit = 10;
    @QManageable(name="needPlayers", min=1, max=100, description="Number of players needed to start")
    private int needPlayers = 2;
    private HashMap<Player, Integer> scores = new HashMap();
    private int[] teamScores = new int[]{0, 0};
    private boolean started = false;
    private BukkitTask warmupTask = null;

    public TDMMatch(QMap map) {
        super(map);
    }

    public TDMMatch(QMap map, UUID ownerId, MatchPrivacy privacy, String password) {
        super(map, ownerId, privacy, password);
    }

    public static String getNameKeyStatic() {
        return "match.tdm.name";
    }

    @Override
    public String getNameKey() {
        return TDMMatch.getNameKeyStatic();
    }

    @Override
    public void setScoreLimit(int scoreLimit) {
        this.fraglimit = scoreLimit;
    }

    @Override
    public void setNeedPlayers(int needPlayers) {
        this.needPlayers = needPlayers;
    }

    @Override
    public void join(Player player, Team team) {
        super.join(player, team);
        this.scores.put(player, 0);
        Team playerTeam = (Team)((Object)this.players.get(player));
        this.sendMessage(TranslationManager.t("match.team.joined.title", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)player.getName()), Placeholder.parsed((String)"team_color", (String)TranslationManager.tLegacy("match.team.joined." + playerTeam.name().toLowerCase() + "Adj", TranslationManager.FALLBACK))}));
        this.updateScoreboard();
        if (this.players.size() >= this.needPlayers && this.warmupTask == null && !this.started) {
            this.warmup();
        }
    }

    @Override
    public void leave(Player player) {
        super.leave(player);
        this.scores.remove(player);
        this.updateScoreboard();
        if (this.players.isEmpty()) {
            QuakePlugin.INSTANCE.getLogger().warning("Last player of match " + this.getNameKey() + ", " + this.map.name + " has left. Ending match.");
            this.end();
        }
    }

    @Override
    public Team assignTeam(Player player) {
        int blueAmount;
        int redAmount = this.getPlayersInTeam(Team.RED).size();
        if (redAmount >= (blueAmount = this.getPlayersInTeam(Team.BLUE).size())) {
            return Team.BLUE;
        }
        return Team.RED;
    }

    public void warmup() {
        final Set players = this.players.keySet();
        this.warmupTask = new BukkitRunnable(){
            int count = 10;

            public void run() {
                for (Player player : players) {
                    player.showTitle(Title.title((Component)TranslationManager.t(TDMMatch.this.getNameKey(), player, new TagResolver[0]), (Component)TranslationManager.t("match.countdown", player, new TagResolver[]{Placeholder.unparsed((String)"count", (String)String.valueOf(this.count))}), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(1200L), (Duration)Duration.ZERO)));
                }
                --this.count;
                if (this.count == -1) {
                    TDMMatch.this.start();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 20L);
    }

    public void start() {
        this.map.prepareForMatch(this);
        for (Player player : this.players.keySet()) {
            this.scores.put(player, 0);
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            userState.reset();
            userState.respawn();
        }
        this.started = true;
        this.updateScoreboard();
        for (Player player : this.players.keySet()) {
            player.showTitle(Title.title((Component)TranslationManager.t("match.start", player, new TagResolver[0]), (Component)TranslationManager.t("match.generic.startMessage", player, new TagResolver[]{Placeholder.unparsed((String)"fraglimit", (String)String.valueOf(this.fraglimit))}).color(TextColor.color((int)0xFF0000)), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(500L))));
        }
    }

    @Override
    public void end() {
        this.map.cleanup();
        super.end();
    }

    private Component getScoreboard() {
        ArrayList<Map.Entry<Player, Integer>> sortedScores = new ArrayList<Map.Entry<Player, Integer>>(this.scores.entrySet());
        sortedScores.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        TableBuilder redTableBuilder = new TableBuilder();
        redTableBuilder.addRow("Score", "Ping", "Name");
        redTableBuilder.addRow("", "", "");
        for (Map.Entry entry : sortedScores) {
            if (this.players.get(entry.getKey()) != Team.RED) continue;
            redTableBuilder.addRow(((Integer)entry.getValue()).toString(), String.valueOf(((Player)entry.getKey()).getPing()), ((Player)entry.getKey()).getName());
        }
        TableBuilder blueTableBuilder = new TableBuilder();
        blueTableBuilder.addRow("Score", "Ping", "Name");
        blueTableBuilder.addRow("", "", "");
        for (Map.Entry entry : sortedScores) {
            if (this.players.get(entry.getKey()) != Team.BLUE) continue;
            blueTableBuilder.addRow(((Integer)entry.getValue()).toString(), String.valueOf(((Player)entry.getKey()).getPing()), ((Player)entry.getKey()).getName());
        }
        Component component = ((TextComponent)Component.text((String)redTableBuilder.build()).font(Key.key((String)"mono"))).color(TextColor.color((int)Team.Colors.get(Team.RED)));
        Component component2 = ((TextComponent)Component.text((String)blueTableBuilder.build()).font(Key.key((String)"mono"))).color(TextColor.color((int)Team.Colors.get(Team.BLUE)));
        return ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(component)).appendNewline()).appendNewline()).append(component2);
    }

    private Component getHeaderComponent() {
        Component header = this.teamScores[1] > this.teamScores[0] ? TranslationManager.t("match.team.leads.blue", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"blue_score", (String)String.valueOf(this.teamScores[1])), Placeholder.unparsed((String)"red_score", (String)String.valueOf(this.teamScores[0]))}) : (this.teamScores[0] > this.teamScores[1] ? TranslationManager.t("match.team.leads.red", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"red_score", (String)String.valueOf(this.teamScores[0])), Placeholder.unparsed((String)"blue_score", (String)String.valueOf(this.teamScores[1]))}) : TranslationManager.t("match.team.leads.tied", TranslationManager.FALLBACK, new TagResolver[0]));
        return header.appendNewline();
    }

    private void updateScoreboard() {
        for (Player player : this.players.keySet()) {
            Component header = this.getHeaderComponent();
            player.sendPlayerListHeaderAndFooter(header, this.getScoreboard());
        }
    }

    @Override
    public void onDeath(Player victim, Entity attacker, DamageCause cause) {
        block24: {
            block21: {
                Player pAttacker;
                block23: {
                    Integer oldScore;
                    block22: {
                        super.onDeath(victim, attacker, cause);
                        for (Player viewer : this.players.keySet()) {
                            viewer.sendMessage(TDMMatch.getDeathMessage(victim, attacker, cause, viewer.locale()));
                        }
                        if (!this.started) {
                            return;
                        }
                        if (!(attacker instanceof Player)) break block21;
                        pAttacker = (Player)attacker;
                        if (victim == attacker) break block21;
                        boolean sameTeam = this.getPlayersInTeam((Team)((Object)this.players.get(pAttacker))).contains(victim);
                        oldScore = this.scores.putIfAbsent(pAttacker, 0);
                        if (oldScore == null) {
                            oldScore = 0;
                        }
                        if (sameTeam) break block22;
                        this.scores.put(pAttacker, oldScore + 1);
                        switch ((Team)((Object)this.players.get(pAttacker))) {
                            case RED: {
                                this.teamScores[0] = this.teamScores[0] + 1;
                                break block23;
                            }
                            case BLUE: {
                                this.teamScores[1] = this.teamScores[1] + 1;
                                break block23;
                            }
                            default: {
                                throw new IllegalArgumentException("Got a kill not from red or blue teams");
                            }
                        }
                    }
                    this.scores.put(pAttacker, oldScore - 1);
                    switch ((Team)((Object)this.players.get(pAttacker))) {
                        case RED: {
                            this.teamScores[0] = this.teamScores[0] - 1;
                            break;
                        }
                        case BLUE: {
                            this.teamScores[1] = this.teamScores[1] - 1;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Got a teamkill not from red or blue teams");
                        }
                    }
                }
                pAttacker.showTitle(Title.title((Component)TranslationManager.t("game.kill.message", pAttacker, new TagResolver[]{Placeholder.unparsed((String)"victim", (String)victim.getName())}), (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L))));
                break block24;
            }
            if (attacker == null || victim == attacker) {
                Integer oldScore = this.scores.get(victim);
                this.scores.put(victim, oldScore - 1);
                switch ((Team)((Object)this.players.get(victim))) {
                    case RED: {
                        this.teamScores[0] = this.teamScores[0] - 1;
                        break;
                    }
                    case BLUE: {
                        this.teamScores[1] = this.teamScores[1] - 1;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Got a teamkill not from red or blue teams");
                    }
                }
                victim.playSound((Entity)victim, "quake.feedback.score_down", SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
        this.updateScoreboard();
        TextComponent winningTeam = Component.text((String)"(unknown)");
        if (this.teamScores[0] > this.teamScores[1]) {
            winningTeam = Component.text((String)"RED").color(TextColor.color((int)Team.Colors.get(Team.RED)));
        } else if (this.teamScores[1] > this.teamScores[0]) {
            winningTeam = Component.text((String)"BLUE").color(TextColor.color((int)Team.Colors.get(Team.BLUE)));
        }
        if (this.teamScores[0] == this.fraglimit || this.teamScores[1] == this.fraglimit) {
            for (Player player : this.players.keySet()) {
                Team winner = this.teamScores[0] > this.teamScores[1] ? Team.RED : Team.BLUE;
                player.showTitle(Title.title((Component)TranslationManager.t("match.team.wins.title", player, new TagResolver[]{Placeholder.parsed((String)"team_color", (String)TranslationManager.tLegacy("match.team.wins." + winner.name().toLowerCase() + "Adj", player))}), (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L))));
                player.sendMessage(this.getScoreboard());
            }
            this.end();
        }
    }

    @Override
    public List<Team> allowedTeams() {
        return List.of(Team.RED, Team.BLUE);
    }
}

