/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.matchmaking.matches;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.game.combat.DeathMessages;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.map.QMap;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchPrivacy;
import com.github.polyzium.quakechasm.matchmaking.matches.QManageable;
import com.github.polyzium.quakechasm.misc.Chatroom;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public abstract class Match
implements ForwardingAudience {
    protected QMap map;
    protected HashMap<Player, Team> players = new HashMap();
    protected Scoreboard vanillaScoreboard;
    protected org.bukkit.scoreboard.Team vanillaRedTeam;
    protected org.bukkit.scoreboard.Team vanillaBlueTeam;
    public boolean matchEnding = false;
    protected UUID ownerId;
    protected MatchPrivacy privacy;
    protected String passwordHash;
    protected HashSet<UUID> invitedPlayers;

    public Match(QMap map) {
        this(map, null, MatchPrivacy.PUBLIC, null);
    }

    public Match(QMap map, UUID ownerId, MatchPrivacy privacy, String password) {
        this.map = map;
        this.ownerId = ownerId;
        this.privacy = privacy != null ? privacy : MatchPrivacy.PUBLIC;
        this.invitedPlayers = new HashSet();
        if (password != null && !password.isEmpty()) {
            this.setPassword(password);
        }
        this.map.chunkLoad();
        if (this.isTeamMatch()) {
            this.vanillaScoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            this.vanillaRedTeam = this.vanillaScoreboard.registerNewTeam("red");
            this.vanillaBlueTeam = this.vanillaScoreboard.registerNewTeam("blue");
            this.vanillaRedTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
            this.vanillaBlueTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.FOR_OTHER_TEAMS);
        }
    }

    public List<Player> getPlayers() {
        return this.players.keySet().stream().toList();
    }

    public List<Player> getPlayersInTeam(Team team) {
        return this.players.keySet().stream().filter(player -> this.players.get(player) == team).toList();
    }

    public QMap getMap() {
        return this.map;
    }

    public static String getNameStatic() {
        return "MATCH_BASE";
    }

    public String getNameKey() {
        return Match.getNameStatic();
    }

    public void sendMessage(String message) {
        this.sendMessage((Component)Component.text((String)message));
    }

    public Team getTeamOfPlayer(Player player) {
        return this.players.get(player);
    }

    public abstract void setScoreLimit(int var1);

    public abstract void setNeedPlayers(int var1);

    public void join(Player player, Team team) {
        Team resolvedTeam = team == null ? this.assignTeam(player) : team;
        if (!this.allowedTeams().contains((Object)resolvedTeam)) {
            QuakePlugin.INSTANCE.getLogger().warning("Player attempted to join disallowed team, ignoring");
            return;
        }
        this.players.put(player, resolvedTeam);
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        userState.currentMatch = this;
        Location spawn = this.map.getRandomSpawnpoint(resolvedTeam);
        player.teleport(spawn);
        MiscUtil.teleEffect(spawn, false);
        userState.initForMatch();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            player.unlistPlayer(onlinePlayer);
        }
        if (this.isTeamMatch()) {
            switch (this.players.get(player)) {
                case RED: {
                    this.vanillaRedTeam.addPlayer((OfflinePlayer)player);
                    break;
                }
                case BLUE: {
                    this.vanillaBlueTeam.addPlayer((OfflinePlayer)player);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Attempt to add player of disallowed team to vanilla team");
                }
            }
            player.setScoreboard(this.vanillaScoreboard);
            Match.setArmor(player, resolvedTeam);
        }
        userState.switchChat(Chatroom.MATCH);
        this.sendMessage(TranslationManager.t("match.player.joined", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)player.getName())}));
    }

    public void leave(Player player) {
        this.players.remove(player);
        this.cleanup(player);
        this.sendMessage(TranslationManager.t("match.player.left", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)player.getName())}));
    }

    public void end() {
        this.matchEnding = true;
        this.clearInvites();
        for (Player player : this.players.keySet()) {
            player.playSound((Entity)player, "quake.feedback.match_end", SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        final Match that = this;
        new BukkitRunnable(){
            int endTimer = 10;

            public void run() {
                --this.endTimer;
                if (this.endTimer <= 5) {
                    that.showTitle(Title.title((Component)Component.empty(), (Component)TranslationManager.t("match.end.teleportCountdown", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"count", (String)String.valueOf(this.endTimer))}), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L))));
                }
                if (this.endTimer == 0) {
                    for (Player player : Match.this.players.keySet()) {
                        Match.this.cleanup(player);
                    }
                    if (that.isTeamMatch()) {
                        that.vanillaRedTeam.unregister();
                        that.vanillaBlueTeam.unregister();
                    }
                    QuakePlugin.INSTANCE.matchManager.matches.remove(that);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 20L, 20L);
    }

    public abstract Team assignTeam(Player var1);

    public static void setArmor(Player player, Team team) {
        ItemStack torso = new ItemStack(Material.LEATHER_CHESTPLATE);
        ItemStack pants = new ItemStack(Material.LEATHER_LEGGINGS);
        ItemStack boots = new ItemStack(Material.LEATHER_BOOTS);
        LeatherArmorMeta torsoMeta = (LeatherArmorMeta)torso.getItemMeta();
        LeatherArmorMeta pantsMeta = (LeatherArmorMeta)pants.getItemMeta();
        LeatherArmorMeta bootsMeta = (LeatherArmorMeta)boots.getItemMeta();
        torsoMeta.setColor(Color.fromRGB((int)Team.Colors.get(team)));
        pantsMeta.setColor(Color.fromRGB((int)Team.Colors.get(team)));
        bootsMeta.setColor(Color.fromRGB((int)Team.Colors.get(team)));
        torso.setItemMeta((ItemMeta)torsoMeta);
        pants.setItemMeta((ItemMeta)pantsMeta);
        boots.setItemMeta((ItemMeta)bootsMeta);
        player.getInventory().setChestplate(torso);
        player.getInventory().setLeggings(pants);
        player.getInventory().setBoots(boots);
    }

    public void cleanup(Player player) {
        QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
        userState.currentMatch = null;
        userState.switchChat(Chatroom.GLOBAL);
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        player.setWalkSpeed(QuakePlugin.INSTANCE.config.player.walkSpeed);
        MiscUtil.teleEffect(player.getLocation(), true);
        player.teleport(QuakePlugin.LOBBY);
        userState.reset();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            player.listPlayer(onlinePlayer);
        }
        player.sendPlayerListHeaderAndFooter((Component)Component.empty(), (Component)Component.empty());
    }

    public void onDeath(Player victim, Entity attacker, DamageCause cause) {
        QuakeUserState victimState = QuakePlugin.INSTANCE.userStates.get(victim);
        victimState.consecutiveRailgunHits = 0;
        victimState.lastKillTime = 0L;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (attacker != victim) {
                QuakeUserState attackerState = QuakePlugin.INSTANCE.userStates.get(player);
                attackerState.checkExcellentMedal();
                attackerState.lastKillTime = System.currentTimeMillis();
            }
        }
    }

    public abstract List<Team> allowedTeams();

    public boolean isTeamMatch() {
        List<Team> allowedTeams = this.allowedTeams();
        return allowedTeams.contains((Object)Team.RED) && allowedTeams.contains((Object)Team.BLUE);
    }

    public static Component getDeathMessage(Player victim, Entity attacker, DamageCause cause, Locale locale) {
        Component component;
        if (attacker == null || victim == attacker) {
            String deathMsgKey = DeathMessages.SUICIDE.get((Object)cause);
            if (deathMsgKey == null) {
                deathMsgKey = "obituary.suicide.unknown";
            }
            component = TranslationManager.t(deathMsgKey, locale, new TagResolver[]{Placeholder.parsed((String)"victim_name", (String)victim.getName()), Placeholder.parsed((String)"death_cause", (String)cause.name())});
        } else {
            String deathMsgKey = DeathMessages.FRAG.get((Object)cause);
            if (deathMsgKey == null) {
                deathMsgKey = "obituary.unknown";
            }
            component = TranslationManager.t(deathMsgKey, locale, new TagResolver[]{Placeholder.parsed((String)"victim_name", (String)victim.getName()), Placeholder.parsed((String)"attacker_name", (String)attacker.getName()), Placeholder.parsed((String)"death_cause", (String)cause.name())});
        }
        return component.color(TextColor.color((int)0xFF3F3F));
    }

    public Audience getTeamAudience(Team team) {
        return Audience.audience(this.getPlayersInTeam(team));
    }

    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.players.keySet();
    }

    public boolean isOwner(Player player) {
        if (this.ownerId == null) {
            return false;
        }
        return this.ownerId.equals(player.getUniqueId());
    }

    public boolean canManage(Player player) {
        return this.isOwner(player) || player.hasPermission("quake.admin");
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setOwner(UUID playerId) {
        this.ownerId = playerId;
    }

    public MatchPrivacy getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(MatchPrivacy privacy) {
        this.privacy = privacy;
    }

    public boolean isPasswordProtected() {
        return this.passwordHash != null;
    }

    public boolean checkPassword(String password) {
        if (this.passwordHash == null) {
            return true;
        }
        if (password == null) {
            return false;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            return this.passwordHash.equals(Match.bytesToHex(hash));
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public void setPassword(String password) {
        if (password == null || password.isEmpty()) {
            this.passwordHash = null;
            return;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            this.passwordHash = Match.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            QuakePlugin.INSTANCE.getLogger().severe("SHA-256 not available!");
            this.passwordHash = null;
        }
    }

    public void removePassword() {
        this.passwordHash = null;
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public boolean isInvited(UUID playerId) {
        return this.invitedPlayers.contains(playerId);
    }

    public void invitePlayer(UUID playerId) {
        this.invitedPlayers.add(playerId);
    }

    public void uninvitePlayer(UUID playerId) {
        this.invitedPlayers.remove(playerId);
    }

    public Set<UUID> getInvitedPlayers() {
        return new HashSet<UUID>(this.invitedPlayers);
    }

    public void clearInvites() {
        this.invitedPlayers.clear();
    }

    public boolean canJoin(Player player, String password) {
        if (player.hasPermission("quake.admin")) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        return switch (this.privacy) {
            case MatchPrivacy.PUBLIC -> true;
            case MatchPrivacy.PASSWORD -> {
                if (this.isInvited(player.getUniqueId())) {
                    yield true;
                }
                yield this.checkPassword(password);
            }
            case MatchPrivacy.INVITE_ONLY -> this.isInvited(player.getUniqueId());
            default -> false;
        };
    }

    public Map<String, Object> getManageableProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Class<?> clazz = this.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(QManageable.class)) continue;
            QManageable annotation = field.getAnnotation(QManageable.class);
            try {
                field.setAccessible(true);
                properties.put(annotation.name(), field.get(this));
            }
            catch (IllegalAccessException e) {
                QuakePlugin.INSTANCE.getLogger().warning("Failed to access manageable field: " + field.getName());
            }
        }
        return properties;
    }

    public void setManageableProperty(String propertyName, Object value) throws IllegalArgumentException {
        Class<?> clazz = this.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            QManageable annotation;
            if (!field.isAnnotationPresent(QManageable.class) || !(annotation = field.getAnnotation(QManageable.class)).name().equals(propertyName)) continue;
            try {
                int intValue;
                field.setAccessible(true);
                if (value instanceof Integer && ((intValue = ((Integer)value).intValue()) < annotation.min() || intValue > annotation.max())) {
                    throw new IllegalArgumentException(String.format("Value %d is out of range [%d, %d]", intValue, annotation.min(), annotation.max()));
                }
                field.set(this, value);
                return;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot access property: " + propertyName);
            }
        }
        throw new IllegalArgumentException("Property not found or not manageable: " + propertyName);
    }

    public Object getManageableProperty(String propertyName) throws IllegalArgumentException {
        Map<String, Object> properties = this.getManageableProperties();
        if (!properties.containsKey(propertyName)) {
            throw new IllegalArgumentException("Property not found or not manageable: " + propertyName);
        }
        return properties.get(propertyName);
    }

    public QManageable getPropertyAnnotation(String propertyName) {
        Class<?> clazz = this.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            QManageable annotation;
            if (!field.isAnnotationPresent(QManageable.class) || !(annotation = field.getAnnotation(QManageable.class)).name().equals(propertyName)) continue;
            return annotation;
        }
        return null;
    }
}

