/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.matchmaking.matches;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.map.QMap;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchPrivacy;
import com.github.polyzium.quakechasm.matchmaking.matches.QManageable;
import com.github.polyzium.quakechasm.misc.Pair;
import com.github.polyzium.quakechasm.misc.TableBuilder;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class FFAMatch
extends Match {
    @QManageable(name="fraglimit", min=1, max=1000, description="Number of frags needed to win")
    public int fraglimit = 10;
    @QManageable(name="needPlayers", min=1, max=100, description="Number of players needed to start")
    private int needPlayers = 2;
    private HashMap<Player, Integer> scores = new HashMap();
    private boolean started = false;
    private BukkitTask warmupTask = null;

    public FFAMatch(QMap map) {
        super(map);
    }

    public FFAMatch(QMap map, UUID ownerId, MatchPrivacy privacy, String password) {
        super(map, ownerId, privacy, password);
    }

    public static String getNameKeyStatic() {
        return "match.ffa.name";
    }

    @Override
    public String getNameKey() {
        return FFAMatch.getNameKeyStatic();
    }

    @Override
    public void setScoreLimit(int scoreLimit) {
        this.fraglimit = scoreLimit;
    }

    @Override
    public void setNeedPlayers(int needPlayers) {
        this.needPlayers = needPlayers;
    }

    @Override
    public void join(Player player, Team team) {
        super.join(player, team);
        this.scores.put(player, 0);
        this.updateScoreboard();
        if (this.players.size() >= this.needPlayers && this.warmupTask == null && !this.started) {
            this.warmup();
        }
    }

    @Override
    public void leave(Player player) {
        super.leave(player);
        this.scores.remove(player);
        this.updateScoreboard();
        player.sendPlayerListHeaderAndFooter((Component)Component.empty(), (Component)Component.empty());
        if (this.players.isEmpty()) {
            QuakePlugin.INSTANCE.getLogger().warning("Last player of match " + this.getNameKey() + ", " + this.map.name + " has left. Ending match.");
            this.end();
        }
    }

    @Override
    public List<Team> allowedTeams() {
        return List.of(Team.FREE);
    }

    public void warmup() {
        final Set players = this.players.keySet();
        this.warmupTask = new BukkitRunnable(){
            int count = 10;

            public void run() {
                for (Player player : players) {
                    player.showTitle(Title.title((Component)TranslationManager.t(FFAMatch.this.getNameKey(), player, new TagResolver[0]), (Component)TranslationManager.t("match.countdown", player, new TagResolver[]{Placeholder.unparsed((String)"count", (String)String.valueOf(this.count))}), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(1200L), (Duration)Duration.ZERO)));
                }
                --this.count;
                if (this.count == -1) {
                    FFAMatch.this.start();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 20L);
    }

    public void start() {
        this.map.prepareForMatch(this);
        for (Player player : this.players.keySet()) {
            this.scores.put(player, 0);
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            userState.reset();
            userState.respawn();
        }
        this.started = true;
        this.updateScoreboard();
        for (Player player : this.players.keySet()) {
            player.showTitle(Title.title((Component)TranslationManager.t("match.start", player, new TagResolver[0]), (Component)TranslationManager.t("match.generic.startMessage", player, new TagResolver[]{Placeholder.unparsed((String)"fraglimit", (String)String.valueOf(this.fraglimit))}).color(TextColor.color((int)0xFF0000)), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(500L))));
        }
    }

    @Override
    public void end() {
        this.map.cleanup();
        super.end();
    }

    @Override
    public Team assignTeam(Player player) {
        return Team.FREE;
    }

    private Component getScoreboard() {
        TableBuilder tableBuilder = new TableBuilder();
        TextComponent scoreboard = Component.empty();
        ArrayList<Map.Entry<Player, Integer>> sortedScores = new ArrayList<Map.Entry<Player, Integer>>(this.scores.entrySet());
        sortedScores.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        tableBuilder.addRow("Score", "Ping", "Name");
        tableBuilder.addRow("", "", "");
        for (Map.Entry entry : sortedScores) {
            tableBuilder.addRow(((Integer)entry.getValue()).toString(), String.valueOf(((Player)entry.getKey()).getPing()), ((Player)entry.getKey()).getName());
        }
        scoreboard = scoreboard.append(Component.text((String)tableBuilder.build()).font(Key.key((String)"mono")));
        return scoreboard;
    }

    private void updateScoreboard() {
        for (Player player : this.players.keySet()) {
            Component place = this.getPlaceComponent(player);
            place = place.append(TranslationManager.t("match.score.place", player, new TagResolver[]{Placeholder.unparsed((String)"score", (String)String.valueOf(this.scores.get(player)))}).color(TextColor.color((int)0xFFFFFF))).appendNewline();
            player.sendPlayerListHeaderAndFooter(place, this.getScoreboard());
        }
    }

    public Pair<Integer, Boolean> getPlace(Player player) {
        int playerScore = this.scores.get(player);
        int place = 1;
        boolean isTied = false;
        for (Map.Entry<Player, Integer> entry : this.scores.entrySet()) {
            if (!entry.getKey().equals((Object)player) && entry.getValue() > playerScore) {
                ++place;
                continue;
            }
            if (entry.getValue() != playerScore || entry.getKey().equals((Object)player)) continue;
            isTied = true;
        }
        return new Pair<Integer, Boolean>(place, isTied);
    }

    public Component getPlaceComponent(Player player) {
        Pair<Integer, Boolean> place = this.getPlace(player);
        Object formattedPlace = String.valueOf(place.getLeft());
        TextColor placeColor = switch (place.getLeft()) {
            case 1 -> {
                formattedPlace = (String)formattedPlace + TranslationManager.tLegacy("suffix.first", player);
                yield TextColor.color((int)255);
            }
            case 2 -> {
                formattedPlace = (String)formattedPlace + TranslationManager.tLegacy("suffix.second", player);
                yield TextColor.color((int)0xFF0000);
            }
            case 3 -> {
                formattedPlace = (String)formattedPlace + TranslationManager.tLegacy("suffix.third", player);
                yield TextColor.color((int)0xFFFF00);
            }
            default -> {
                formattedPlace = (String)formattedPlace + TranslationManager.tLegacy("suffix.nth", player);
                yield TextColor.color((int)0xFFFFFF);
            }
        };
        Component placeComponent = place.getRight() != false ? TranslationManager.t("match.score.tiedFor", player, new TagResolver[0]).color(TextColor.color((int)0xFFFFFF)).append(Component.text((String)formattedPlace).color(placeColor)) : Component.text((String)formattedPlace).color(placeColor);
        return placeComponent;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onDeath(Player victim, Entity attacker, DamageCause cause) {
        super.onDeath(victim, attacker, cause);
        for (Player viewer : this.players.keySet()) {
            viewer.sendMessage(FFAMatch.getDeathMessage(victim, attacker, cause, viewer.locale()));
        }
        if (!this.started) {
            return;
        }
        if (!(attacker instanceof Player)) ** GOTO lbl-1000
        pAttacker = (Player)attacker;
        if (victim != attacker) {
            oldScore = this.scores.putIfAbsent(pAttacker, 0);
            if (oldScore == null) {
                oldScore = 0;
            }
            this.scores.put(pAttacker, oldScore + 1);
            placeComponent = this.getPlaceComponent(pAttacker);
            pAttacker.showTitle(Title.title((Component)TranslationManager.t("game.kill.message", pAttacker, new TagResolver[]{Placeholder.unparsed((String)"victim", (String)victim.getName())}), (Component)placeComponent.append(TranslationManager.t("match.score.place", pAttacker, new TagResolver[]{Placeholder.unparsed((String)"score", (String)String.valueOf(this.scores.get(pAttacker)))}).color(TextColor.color((int)0xFFFFFF))), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L))));
        } else if (attacker == null || victim == attacker) {
            oldScore = this.scores.get(victim);
            this.scores.put(victim, oldScore - 1);
            victim.playSound((Entity)victim, "quake.feedback.score_down", SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        this.updateScoreboard();
        sortedList = new ArrayList<Map.Entry<Player, Integer>>(this.scores.entrySet());
        sortedList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        winningPlayerEntry = (Map.Entry)sortedList.get(0);
        winningPlayer = (Player)winningPlayerEntry.getKey();
        winningScore = (Integer)winningPlayerEntry.getValue();
        if (winningScore == this.fraglimit) {
            for (Player player : this.players.keySet()) {
                player.showTitle(Title.title((Component)TranslationManager.t("match.generic.wins", player, new TagResolver[]{Placeholder.unparsed((String)"winner", (String)winningPlayer.getName())}), (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L))));
                player.sendMessage(this.getScoreboard());
            }
            this.end();
        }
    }
}

