/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.matchmaking.matches;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.DamageCause;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.game.entities.pickups.CTFFlag;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.map.QMap;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchPrivacy;
import com.github.polyzium.quakechasm.matchmaking.matches.QManageable;
import com.github.polyzium.quakechasm.misc.TableBuilder;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CTFMatch
extends Match {
    @QManageable(name="capturelimit", min=1, max=100, description="Number of captures needed to win")
    private int capturelimit = 10;
    @QManageable(name="needPlayers", min=1, max=100, description="Number of players needed to start")
    private int needPlayers = 2;
    private HashMap<Player, Integer> scores = new HashMap();
    private int[] captures = new int[]{0, 0};
    private Player[] flagCarriers = new Player[]{null, null};
    private boolean started = false;
    private BukkitTask warmupTask = null;
    private BossBar infoBar;

    public CTFMatch(QMap map) {
        super(map);
        this.initCTF();
    }

    public CTFMatch(QMap map, UUID ownerId, MatchPrivacy privacy, String password) {
        super(map, ownerId, privacy, password);
        this.initCTF();
    }

    private void initCTF() {
        this.getRedFlag().prepareForMatch(this);
        this.getBlueFlag().prepareForMatch(this);
        this.infoBar = BossBar.bossBar((Component)Component.empty(), (float)0.0f, (BossBar.Color)BossBar.Color.WHITE, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        this.updateInfo();
    }

    public static String getNameKeyStatic() {
        return "match.ctf.name";
    }

    @Override
    public String getNameKey() {
        return CTFMatch.getNameKeyStatic();
    }

    @Override
    public void setScoreLimit(int scoreLimit) {
        this.capturelimit = scoreLimit;
    }

    @Override
    public void setNeedPlayers(int needPlayers) {
        this.needPlayers = needPlayers;
    }

    @Override
    public void join(Player player, Team team) {
        super.join(player, team);
        this.scores.put(player, 0);
        player.showBossBar(this.infoBar);
        Team playerTeam = (Team)((Object)this.players.get(player));
        this.sendMessage(TranslationManager.t("match.team.joined.title", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)player.getName()), Placeholder.parsed((String)"team_color", (String)TranslationManager.tLegacy("match.team.joined." + playerTeam.name().toLowerCase() + "Adj", TranslationManager.FALLBACK))}));
        this.updateScoreboard();
        if (this.players.size() >= this.needPlayers && this.warmupTask == null && !this.started) {
            this.warmup();
        }
    }

    @Override
    public void leave(Player player) {
        super.leave(player);
        this.scores.remove(player);
        player.hideBossBar(this.infoBar);
        this.updateScoreboard();
        if (this.players.isEmpty()) {
            QuakePlugin.INSTANCE.getLogger().warning("Last player of match " + this.getNameKey() + ", " + this.map.name + " has left. Ending match.");
            this.end();
        }
    }

    @Override
    public Team assignTeam(Player player) {
        int blueAmount;
        int redAmount = this.getPlayersInTeam(Team.RED).size();
        if (redAmount >= (blueAmount = this.getPlayersInTeam(Team.BLUE).size())) {
            return Team.BLUE;
        }
        return Team.RED;
    }

    public void warmup() {
        final Set players = this.players.keySet();
        this.warmupTask = new BukkitRunnable(){
            int count = 10;

            public void run() {
                for (Player player : players) {
                    player.showTitle(Title.title((Component)TranslationManager.t(CTFMatch.this.getNameKey(), player, new TagResolver[0]), (Component)TranslationManager.t("match.countdown", player, new TagResolver[]{Placeholder.unparsed((String)"count", (String)String.valueOf(this.count))}), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(1200L), (Duration)Duration.ZERO)));
                }
                --this.count;
                if (this.count == -1) {
                    CTFMatch.this.start();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 20L);
    }

    public void start() {
        this.map.prepareForMatch(this);
        for (Player player : this.players.keySet()) {
            this.scores.put(player, 0);
            QuakeUserState userState = QuakePlugin.INSTANCE.userStates.get(player);
            userState.reset();
            userState.respawn();
        }
        this.captures = new int[]{0, 0};
        this.flagCarriers = new Player[]{null, null};
        this.started = true;
        this.updateScoreboard();
        for (Player player : this.players.keySet()) {
            player.showTitle(Title.title((Component)TranslationManager.t("match.start", player, new TagResolver[0]), (Component)TranslationManager.t("match.ctf.startMessage", player, new TagResolver[]{Placeholder.unparsed((String)"capturelimit", (String)String.valueOf(this.capturelimit))}).color(TextColor.color((int)0xFF0000)), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(500L))));
        }
    }

    @Override
    public void end() {
        for (Player player : this.players.keySet()) {
            player.hideBossBar(this.infoBar);
        }
        this.map.cleanup();
        super.end();
    }

    public CTFFlag getRedFlag() {
        Collection entities = this.map.world.getNearbyEntities(this.map.bounds);
        for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
            CTFFlag flag;
            if (!entities.contains(trigger.getEntity()) || !(trigger instanceof CTFFlag) || (flag = (CTFFlag)trigger).getTeam() != Team.RED || flag.isDrop()) continue;
            return flag;
        }
        return null;
    }

    public CTFFlag getBlueFlag() {
        Collection entities = this.map.world.getNearbyEntities(this.map.bounds);
        for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
            CTFFlag flag;
            if (!entities.contains(trigger.getEntity()) || !(trigger instanceof CTFFlag) || (flag = (CTFFlag)trigger).getTeam() != Team.BLUE || flag.isDrop()) continue;
            return flag;
        }
        return null;
    }

    public void grabFlag(Team belongingFlagTeam, Player player) {
        PlayerInventory inv = player.getInventory();
        switch (belongingFlagTeam) {
            case RED: {
                this.flagCarriers[0] = player;
                inv.setItemInOffHand(new ItemStack(Material.RED_BANNER));
                break;
            }
            case BLUE: {
                this.flagCarriers[1] = player;
                inv.setItemInOffHand(new ItemStack(Material.BLUE_BANNER));
                break;
            }
            default: {
                throw new IllegalArgumentException("Non-red/non-blue attempted to pick up the flag");
            }
        }
        for (Player matchPlayer : this.players.keySet()) {
            matchPlayer.sendMessage(TranslationManager.t("match.ctf.flag.taken.title", matchPlayer, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)player.getName()), Placeholder.parsed((String)"flag_color", (String)TranslationManager.tLegacy("match.ctf.flag.taken." + belongingFlagTeam.name().toLowerCase() + "Adj", matchPlayer))}));
            Team playerTeam = (Team)((Object)this.players.get(matchPlayer));
            if (playerTeam == belongingFlagTeam) {
                matchPlayer.playSound((Entity)matchPlayer, "quake.feedback.teamplay.flagtaken.yourteam", SoundCategory.NEUTRAL, 1.0f, 1.0f);
                continue;
            }
            matchPlayer.playSound((Entity)matchPlayer, "quake.feedback.teamplay.flagtaken.opponent", SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        this.updateInfo();
    }

    public Team getCarryingFlagTeam(Player carrier) {
        if (this.flagCarriers[0] == carrier) {
            return Team.RED;
        }
        if (this.flagCarriers[1] == carrier) {
            return Team.BLUE;
        }
        return null;
    }

    public void returnFlag(Team team, Player returningPlayer) {
        Collection entities = this.map.world.getNearbyEntities(this.map.bounds);
        for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
            CTFFlag flag;
            if (!entities.contains(trigger.getEntity()) || !(trigger instanceof CTFFlag) || (flag = (CTFFlag)trigger).isDrop() || flag.getTeam() != team) continue;
            for (Player player : this.players.keySet()) {
                if (returningPlayer != null) {
                    player.sendMessage(TranslationManager.t("match.ctf.flag.returnedByPlayer.title", player, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)returningPlayer.getName()), Placeholder.parsed((String)"flag_color", (String)TranslationManager.tLegacy("match.ctf.flag.returnedByPlayer." + team.name().toLowerCase() + "Adj", player))}));
                } else {
                    player.sendMessage(TranslationManager.t("match.ctf.flag.returnedAuto.title", player, new TagResolver[]{Placeholder.parsed((String)"flag_color", (String)TranslationManager.tLegacy("match.ctf.flag.returnedAuto." + team.name().toLowerCase() + "Adj", player))}));
                }
                Team playerTeam = (Team)((Object)this.players.get(player));
                if (playerTeam == team) {
                    player.playSound((Entity)player, "quake.feedback.teamplay.flagreturn.yourteam", SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    continue;
                }
                player.playSound((Entity)player, "quake.feedback.teamplay.flagreturn.opponent", SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            flag.respawn();
            break;
        }
        this.updateInfo();
    }

    public void captureFlag(Team belongingFlagTeam, Player enemyFlagCarrier) {
        PlayerInventory inv = enemyFlagCarrier.getInventory();
        switch (belongingFlagTeam) {
            case RED: {
                this.flagCarriers[1] = null;
                this.getBlueFlag().respawn();
                break;
            }
            case BLUE: {
                this.flagCarriers[0] = null;
                this.getRedFlag().respawn();
                break;
            }
            default: {
                throw new IllegalArgumentException("Non-red/non-blue attempted to capture the flag");
            }
        }
        inv.setItemInOffHand(null);
        this.scoreCapture(belongingFlagTeam, enemyFlagCarrier);
        this.updateInfo();
    }

    public void scoreCapture(Team capturerTeam, Player capturer) {
        if (this.started) {
            switch (capturerTeam) {
                case RED: {
                    this.captures[0] = this.captures[0] + 1;
                    break;
                }
                case BLUE: {
                    this.captures[1] = this.captures[1] + 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("scoreCapture called on non-red/non-blue team");
                }
            }
            Object oldScore = this.scores.putIfAbsent(capturer, 0);
            if (oldScore == null) {
                oldScore = 0;
            }
            this.scores.put(capturer, (Integer)oldScore + 5);
            this.updateScoreboard();
        }
        for (Player player : this.players.keySet()) {
            player.sendMessage(TranslationManager.t("match.ctf.flag.capture.title", player, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)capturer.getName()), Placeholder.parsed((String)"flag_color", (String)TranslationManager.tLegacy("match.ctf.flag.capture." + capturerTeam.oppositeTeam().name().toLowerCase() + "Adj", player))}));
            Component subtitle = this.captures[0] > this.captures[1] ? TranslationManager.t("match.team.leads.red", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"red_score", (String)String.valueOf(this.captures[0])), Placeholder.unparsed((String)"blue_score", (String)String.valueOf(this.captures[1]))}) : (this.captures[1] > this.captures[0] ? TranslationManager.t("match.team.leads.blue", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"blue_score", (String)String.valueOf(this.captures[1])), Placeholder.unparsed((String)"red_score", (String)String.valueOf(this.captures[0]))}) : TranslationManager.t("match.team.leads.tiedWithScore", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"score", (String)String.valueOf(this.captures[0]))}));
            player.showTitle(Title.title((Component)TranslationManager.t("match.ctf.flag.capture.title", player, new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)capturer.getName()), Placeholder.parsed((String)"flag_color", (String)TranslationManager.tLegacy("match.ctf.flag.capture." + capturerTeam.oppositeTeam().name().toLowerCase() + "Adj", player))}), (Component)subtitle, (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L))));
            Team playerTeam = (Team)((Object)this.players.get(player));
            if (playerTeam == capturerTeam) {
                player.playSound((Entity)player, "quake.feedback.teamplay.flagcapture.yourteam", SoundCategory.NEUTRAL, 1.0f, 1.0f);
                continue;
            }
            player.playSound((Entity)player, "quake.feedback.teamplay.flagcapture.opponent", SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        TextComponent winningTeam = Component.text((String)"(unknown)");
        if (this.captures[0] > this.captures[1]) {
            winningTeam = Component.text((String)"RED").color(TextColor.color((int)Team.Colors.get(Team.RED)));
        } else if (this.captures[1] > this.captures[0]) {
            winningTeam = Component.text((String)"BLUE").color(TextColor.color((int)Team.Colors.get(Team.BLUE)));
        }
        if (this.captures[0] == this.capturelimit || this.captures[1] == this.capturelimit) {
            for (Player player : this.players.keySet()) {
                Team winner = this.captures[0] > this.captures[1] ? Team.RED : Team.BLUE;
                player.showTitle(Title.title((Component)TranslationManager.t("match.team.wins.title", player, new TagResolver[]{Placeholder.parsed((String)"team_color", (String)TranslationManager.tLegacy("match.team.wins." + winner.name().toLowerCase() + "Adj", player))}), (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L))));
                player.sendMessage(this.getScoreboard());
            }
            this.end();
        }
    }

    private Component getScoreboard() {
        ArrayList<Map.Entry<Player, Integer>> sortedScores = new ArrayList<Map.Entry<Player, Integer>>(this.scores.entrySet());
        sortedScores.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        TableBuilder redTableBuilder = new TableBuilder();
        redTableBuilder.addRow("Score", "Ping", "Name");
        redTableBuilder.addRow("", "", "");
        for (Map.Entry entry : sortedScores) {
            if (this.players.get(entry.getKey()) != Team.RED) continue;
            redTableBuilder.addRow(((Integer)entry.getValue()).toString(), String.valueOf(((Player)entry.getKey()).getPing()), ((Player)entry.getKey()).getName());
        }
        TableBuilder blueTableBuilder = new TableBuilder();
        blueTableBuilder.addRow("Score", "Ping", "Name");
        blueTableBuilder.addRow("", "", "");
        for (Map.Entry entry : sortedScores) {
            if (this.players.get(entry.getKey()) != Team.BLUE) continue;
            blueTableBuilder.addRow(((Integer)entry.getValue()).toString(), String.valueOf(((Player)entry.getKey()).getPing()), ((Player)entry.getKey()).getName());
        }
        Component component = ((TextComponent)Component.text((String)redTableBuilder.build()).font(Key.key((String)"mono"))).color(TextColor.color((int)Team.Colors.get(Team.RED)));
        Component component2 = ((TextComponent)Component.text((String)blueTableBuilder.build()).font(Key.key((String)"mono"))).color(TextColor.color((int)Team.Colors.get(Team.BLUE)));
        return ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(component)).appendNewline()).appendNewline()).append(component2);
    }

    private void updateInfo() {
        char redFlagIcon = this.flagCarriers[0] != null ? (char)'J' : (this.getRedFlag().getDisplay().getItemStack().isEmpty() ? (char)'K' : 'I');
        char blueFlagIcon = this.flagCarriers[1] != null ? (char)'G' : (this.getBlueFlag().getDisplay().getItemStack().isEmpty() ? (char)'H' : 'F');
        Component redStatus = ((TextComponent)Component.text((int)this.captures[0]).color(TextColor.color((int)Team.Colors.get(Team.RED)))).append(Component.text((char)redFlagIcon).color(TextColor.color((int)0xFFFFFF)));
        Component blueStatus = ((TextComponent)Component.text((int)this.captures[1]).color(TextColor.color((int)Team.Colors.get(Team.BLUE)))).append(Component.text((char)blueFlagIcon).color(TextColor.color((int)0xFFFFFF)));
        this.infoBar.name(((TextComponent)((TextComponent)((TextComponent)Component.empty().append(redStatus)).append((Component)Component.text((String)" "))).append(blueStatus)).font(Key.key((String)"hud_bossbar")));
    }

    private Component getHeaderComponent() {
        Component header = this.captures[1] > this.captures[0] ? TranslationManager.t("match.team.leads.blue", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"blue_score", (String)String.valueOf(this.captures[1])), Placeholder.unparsed((String)"red_score", (String)String.valueOf(this.captures[0]))}) : (this.captures[0] > this.captures[1] ? TranslationManager.t("match.team.leads.red", TranslationManager.FALLBACK, new TagResolver[]{Placeholder.unparsed((String)"red_score", (String)String.valueOf(this.captures[0])), Placeholder.unparsed((String)"blue_score", (String)String.valueOf(this.captures[1]))}) : TranslationManager.t("match.team.leads.tied", TranslationManager.FALLBACK, new TagResolver[0]));
        return header.appendNewline();
    }

    private void updateScoreboard() {
        for (Player player : this.players.keySet()) {
            Component header = this.getHeaderComponent();
            player.sendPlayerListHeaderAndFooter(header, this.getScoreboard());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onDeath(Player victim, Entity attacker, DamageCause cause) {
        super.onDeath(victim, attacker, cause);
        for (Player viewer : this.players.keySet()) {
            viewer.sendMessage(CTFMatch.getDeathMessage(victim, attacker, cause, viewer.locale()));
        }
        if (!(attacker instanceof Player)) ** GOTO lbl-1000
        pAttacker = (Player)attacker;
        if (victim != attacker) {
            sameTeam = this.getPlayersInTeam((Team)this.players.get(pAttacker)).contains(victim);
            oldScores = this.scores.putIfAbsent(pAttacker, 0);
            if (oldScores == null) {
                oldScores = 0;
            }
            if (!sameTeam && this.started) {
                this.scores.put(pAttacker, oldScores + 1);
            } else {
                this.scores.put(pAttacker, oldScores - 1);
            }
            pAttacker.showTitle(Title.title((Component)TranslationManager.t("game.kill.message", pAttacker, new TagResolver[]{Placeholder.unparsed((String)"victim", (String)victim.getName())}), (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L))));
        } else if ((attacker == null || victim == attacker) && this.started) {
            oldKills = this.scores.get(victim);
            this.scores.put(victim, oldKills - 1);
        }
        loc = victim.getLocation();
        loc.setY(loc.y() + 0.5);
        carryingFlagTeam = this.getCarryingFlagTeam(victim);
        if (carryingFlagTeam != null) {
            if (victim.getLocation().y() > -64.0) {
                new CTFFlag(carryingFlagTeam, true, this, loc);
            } else if (victim.getLocation().y() < -64.0) {
                this.returnFlag(carryingFlagTeam, null);
            }
            switch (2.$SwitchMap$com$github$polyzium$quakechasm$matchmaking$Team[carryingFlagTeam.ordinal()]) {
                case 1: {
                    this.flagCarriers[0] = null;
                    break;
                }
                case 2: {
                    this.flagCarriers[1] = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Attempted to drop flag belonging to non-red/non-blue team");
                }
            }
            this.updateInfo();
        }
        this.updateScoreboard();
    }

    @Override
    public List<Team> allowedTeams() {
        return List.of(Team.RED, Team.BLUE);
    }
}

