/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.matchmaking.map;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.game.entities.pickups.CTFFlag;
import com.github.polyzium.quakechasm.game.entities.pickups.PowerupSpawner;
import com.github.polyzium.quakechasm.game.entities.pickups.Spawner;
import com.github.polyzium.quakechasm.matchmaking.Team;
import com.github.polyzium.quakechasm.matchmaking.map.Spawnpoint;
import com.github.polyzium.quakechasm.matchmaking.matches.CTFMatch;
import com.github.polyzium.quakechasm.matchmaking.matches.Match;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchManager;
import com.github.polyzium.quakechasm.matchmaking.matches.MatchMode;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.BoundingBox;

public class QMap {
    public String name;
    public String displayName;
    public World world;
    public BoundingBox bounds;
    public ArrayList<Spawnpoint> spawnPoints;
    public ArrayList<MatchMode> recommendedModes;
    public int neededPlayers;

    public QMap() {
    }

    public QMap(String name, String displayName, World world, BoundingBox bounds, ArrayList<Spawnpoint> spawnPoints, ArrayList<MatchMode> recommendedModes, int neededPlayers) {
        this.name = name;
        this.displayName = displayName;
        this.world = world;
        this.bounds = bounds;
        this.spawnPoints = spawnPoints;
        this.recommendedModes = recommendedModes;
        this.neededPlayers = neededPlayers;
    }

    public void chunkLoad() {
        for (Chunk chunk : this.getChunks()) {
            chunk.setForceLoaded(true);
            chunk.load();
        }
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = (int)Math.floor(this.bounds.getMinX()) >> 4;
        int minZ = (int)Math.floor(this.bounds.getMinZ()) >> 4;
        int maxX = (int)Math.floor(this.bounds.getMaxX()) >> 4;
        int maxZ = (int)Math.floor(this.bounds.getMaxZ()) >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Chunk chunk = this.world.getChunkAt(x, z);
                if (!MiscUtil.chunkIntersectsBoundingBox(chunk, this.bounds)) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public Location getRandomSpawnpoint(Team team) {
        Predicate<Spawnpoint> belongsToTeam = spawnpoint -> spawnpoint.allowedTeams.contains((Object)team);
        Predicate<Spawnpoint> freeIfTeam = spawnpoint -> (team == Team.RED || team == Team.BLUE) && spawnpoint.allowedTeams.contains((Object)Team.FREE);
        Predicate<Spawnpoint> teamIfFree = spawnpoint -> team == Team.FREE && (spawnpoint.allowedTeams.contains((Object)Team.RED) || spawnpoint.allowedTeams.contains((Object)Team.BLUE));
        List<Spawnpoint> allowedSpawnpoints = this.spawnPoints.stream().filter(sp -> belongsToTeam.test((Spawnpoint)sp) || freeIfTeam.test((Spawnpoint)sp) || teamIfFree.test((Spawnpoint)sp)).toList();
        Spawnpoint spawnPoint = allowedSpawnpoints.get((int)(Math.random() * (double)(allowedSpawnpoints.size() - 1)));
        Location spLoc = spawnPoint.pos;
        return spLoc;
    }

    public void despawnPowerups(Match match) {
        Collection entities = this.world.getNearbyEntities(this.bounds);
        for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
            if (!entities.contains(trigger.getEntity()) || !(trigger instanceof PowerupSpawner)) continue;
            PowerupSpawner powerupSpawner = (PowerupSpawner)trigger;
            powerupSpawner.despawn(match);
        }
    }

    public void respawnItems() {
        Collection entities = this.world.getNearbyEntities(this.bounds);
        for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
            if (!entities.contains(trigger.getEntity()) || !(trigger instanceof Spawner)) continue;
            Spawner spawner = (Spawner)trigger;
            spawner.respawn();
        }
    }

    public void prepareForMatch(Match match) {
        this.respawnItems();
        this.despawnPowerups(match);
        if (match instanceof CTFMatch) {
            CTFMatch ctf = (CTFMatch)match;
            Collection entities = this.world.getNearbyEntities(this.bounds);
            for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
                if (!entities.contains(trigger.getEntity()) || !(trigger instanceof CTFFlag)) continue;
                CTFFlag flag = (CTFFlag)trigger;
                flag.prepareForMatch(ctf);
            }
        }
    }

    public Match getMatch() {
        for (Match match : MatchManager.INSTANCE.matches) {
            if (match.getMap() != this) continue;
            return match;
        }
        return null;
    }

    public void cleanup() {
        Collection entities = this.world.getNearbyEntities(this.bounds);
        ArrayList<PowerupSpawner> powerupsForCleanup = new ArrayList<PowerupSpawner>();
        for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
            if (!entities.contains(trigger.getEntity())) continue;
            if (trigger instanceof PowerupSpawner) {
                PowerupSpawner powerupSpawner = (PowerupSpawner)trigger;
                powerupsForCleanup.add(powerupSpawner);
                continue;
            }
            if (trigger instanceof CTFFlag) {
                CTFFlag flag = (CTFFlag)trigger;
                flag.cleanup();
                continue;
            }
            if (!(trigger instanceof Spawner)) continue;
            Spawner spawner = (Spawner)trigger;
            spawner.respawn();
        }
        for (PowerupSpawner powerupSpawner : powerupsForCleanup) {
            powerupSpawner.matchCleanup();
        }
        for (Chunk chunk : this.getChunks()) {
            chunk.setForceLoaded(false);
            chunk.unload();
        }
    }
}

