/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.matchmaking;

import java.util.EnumMap;

public enum Team {
    RED,
    BLUE,
    FREE,
    SPECTATOR;


    public Team oppositeTeam() {
        switch (this.ordinal()) {
            case 0: {
                return BLUE;
            }
            case 1: {
                return RED;
            }
        }
        throw new IllegalArgumentException("Cannot find opposite of a non-red/non-blue team");
    }

    public static class Colors {
        private static EnumMap<Team, Integer> COLORS = new EnumMap(Team.class);

        public static int get(Team team) {
            return COLORS.get((Object)team);
        }

        static {
            COLORS.put(RED, 0xFF3F3F);
            COLORS.put(BLUE, 0x3F3FFF);
            COLORS.put(FREE, 0xFFFF00);
            COLORS.put(SPECTATOR, 65280);
        }
    }
}

