/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.hud;

import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.powerup.Powerup;
import com.github.polyzium.quakechasm.game.combat.powerup.PowerupType;
import fr.mrmicky.fastboard.adventure.FastBoard;
import java.util.ArrayList;
import java.util.EnumMap;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.RGBLike;

public class PowerupBoard {
    QuakeUserState state;
    FastBoard board;
    private boolean needsUpdate;
    public static EnumMap<PowerupType, Character> ICONS = new EnumMap(PowerupType.class);

    public PowerupBoard(QuakeUserState state) {
        this.state = state;
        this.board = new FastBoard(this.state.getPlayer());
    }

    public void rebuild() {
        this.board = new FastBoard(this.state.getPlayer());
    }

    public void update() {
        this.needsUpdate = true;
    }

    public void draw() {
        if (this.board.isDeleted() && this.state.activePowerups.isEmpty() || !this.needsUpdate) {
            return;
        }
        if (this.state.activePowerups.isEmpty()) {
            this.board.delete();
            return;
        }
        if (this.board.isDeleted()) {
            this.rebuild();
        }
        ArrayList<Object> lines = new ArrayList<Object>(3);
        for (int i = 0; i < this.state.activePowerups.size(); ++i) {
            Powerup powerup = this.state.activePowerups.get(i);
            Component icon = Component.text((char)ICONS.get((Object)powerup.getType()).charValue()).font(Key.key((String)"hud"));
            Component time = ((TextComponent)Component.text((int)powerup.getTime()).color(TextColor.color((RGBLike)TextColor.color((int)0xFF3F3F)))).font(Key.key((String)"hud"));
            Component component = Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{icon, time});
            lines.add(Component.empty());
            lines.add(component);
            lines.add(Component.empty());
            lines.add(Component.empty());
        }
        this.board.updateLines(lines);
        this.needsUpdate = false;
    }

    static {
        ICONS.put(PowerupType.QUAD_DAMAGE, Character.valueOf('C'));
        ICONS.put(PowerupType.REGENERATION, Character.valueOf('D'));
        ICONS.put(PowerupType.PROTECTION, Character.valueOf('E'));
    }
}

