/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.hud;

import com.github.polyzium.quakechasm.QuakeUserState;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.hud.PowerupBoard;
import java.time.Duration;
import java.util.ArrayList;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.RGBLike;
import org.bukkit.entity.Player;

public class Hud {
    public PowerupBoard powerupBoard;
    private int ticksPassed = 0;
    private boolean lowHealthFlashing;

    public Hud(QuakeUserState state) {
        this.powerupBoard = new PowerupBoard(state);
    }

    public static void pickupMessage(Player player, Component text) {
        player.showTitle(Title.title((Component)Component.empty(), (Component)text, (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ZERO, (Duration)Duration.ofSeconds(1L))));
    }

    public void draw(QuakeUserState state) {
        Player player = state.getPlayer();
        if (this.ticksPassed >= 4) {
            this.lowHealthFlashing = !this.lowHealthFlashing;
            this.ticksPassed = 0;
        }
        ++this.ticksPassed;
        ArrayList<Object> components = new ArrayList<Object>(6);
        TextColor ammoColor = TextColor.color((int)0xFFAF00);
        int heldWeapon = WeaponUtil.getHoldingWeaponIndex(player);
        if (heldWeapon != -1 && heldWeapon != 0 && heldWeapon != 3 && heldWeapon != 5 && state.weaponState.cooldowns[heldWeapon] != 0) {
            float cooldownFactor = (float)state.weaponState.cooldowns[heldWeapon] / (float)WeaponUtil.PERIODS[heldWeapon] * 0.75f + 0.25f;
            ammoColor = TextColor.color((float)(cooldownFactor * 0.5f), (float)(cooldownFactor * 0.5f), (float)(cooldownFactor * 0.5f));
        }
        if (heldWeapon != -1) {
            components.add(Component.text((char)((char)(97 + heldWeapon))).append(Component.text((String)String.format("%-3d", state.weaponState.ammo[heldWeapon])).color(TextColor.color((RGBLike)ammoColor))));
        } else {
            components.add(Component.text((String)"    "));
        }
        TextColor healthColor = TextColor.color((int)0xFFAF00);
        double health = player.getHealth();
        if (health > 20.0) {
            healthColor = TextColor.color((int)0xFFFFFF);
        } else if (health <= 5.0 && this.lowHealthFlashing) {
            healthColor = TextColor.color((int)0xFF3F3F);
        }
        components.add(Component.text((char)'A').append(Component.text((String)String.format("%-3d", (int)Math.round(health * 5.0))).color(healthColor)));
        components.add(Component.text((char)'B').append(Component.text((String)String.format("%-3d", state.armor)).color(TextColor.color((int)0xFFAF00))));
        player.sendActionBar(Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)" ")), components).font(Key.key((String)"hud")));
        this.powerupBoard.draw();
    }
}

