/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.movement;

import com.github.polyzium.quakechasm.QuakeUserState;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class StrafeJumpHandler {
    private static final int TICK_INTERVAL = 5;
    private static final double AIR_ACCELERATION = 1.0;
    private static final double MAX_SPEED_MULTIPLIER = 9.0;
    private static final double ANGLE_THRESHOLD = 0.95;

    public static void applyStrafeAcceleration(Player player, QuakeUserState userState, Vector velocity) {
        if (player.isOnGround() || player.isFlying() || player.isSneaking() || !player.isSprinting()) {
            return;
        }
        Vector horizontalVel = velocity.clone().setY(0);
        if (horizontalVel.lengthSquared() < 0.01) {
            return;
        }
        Vector lookDir = player.getEyeLocation().getDirection();
        double alignment = lookDir.dot(horizontalVel.normalize());
        if (Math.abs(alignment) < 0.95 && userState.strafeJumpTicks % 5 == 0) {
            double maxSpeed;
            double baseSpeed = player.getWalkSpeed() * 5.0f;
            double currentSpeed = horizontalVel.length();
            if (currentSpeed >= (maxSpeed = baseSpeed * 9.0)) {
                return;
            }
            double accelFactor = (0.95 - Math.abs(alignment)) / 0.95;
            lookDir.setY(0);
            lookDir.normalize();
            Vector acceleration = lookDir.multiply(1.0 * accelFactor);
            velocity.add(acceleration);
            Vector newHorizontalVel = velocity.clone().setY(0);
            if (newHorizontalVel.length() > maxSpeed) {
                newHorizontalVel.normalize().multiply(maxSpeed);
                velocity.setX(newHorizontalVel.getX());
                velocity.setZ(newHorizontalVel.getZ());
            }
            velocity.setY(velocity.getY() - 0.08);
            velocity.setX(velocity.getX());
            velocity.setZ(velocity.getZ());
            player.setVelocity(velocity);
        }
    }
}

