/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.mapper;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.entities.triggers.Portal;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.util.Arrays;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PortalTool {
    public static ItemStack createPortalTool() {
        ItemStack tool = new ItemStack(Material.ENDER_PEARL);
        ItemMeta meta = tool.getItemMeta();
        meta.displayName(TranslationManager.t("mapper.tool.portal.name", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.ITALIC, false));
        meta.lore(Arrays.asList(TranslationManager.t("mapper.tool.portal.lore.pointAtPortal", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.portal.lore.leftClickEdit", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.portal.lore.pointAtBlock", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.portal.lore.rightClickPlace", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.portal.lore.rightClickTarget", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false), TranslationManager.t("mapper.tool.portal.lore.leftClickCancel", TranslationManager.FALLBACK, new TagResolver[0]).color((TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false)));
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "portal_tool"), PersistentDataType.BOOLEAN, (Object)true);
        tool.setItemMeta(meta);
        return tool;
    }

    public static boolean isPortalTool(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "portal_tool"), PersistentDataType.BOOLEAN);
    }

    public static class PortalToolData {
        public PortalToolState state = PortalToolState.IDLE;
        public Location portalLocation = null;
        public Portal editingPortal = null;

        public void reset() {
            this.state = PortalToolState.IDLE;
            this.portalLocation = null;
            this.editingPortal = null;
        }
    }

    public static enum PortalToolState {
        IDLE,
        PLACING_PORTAL,
        SETTING_TARGET,
        EDITING_TARGET;

    }
}

