/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.mapper;

import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.entities.triggers.Jumppad;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.time.Duration;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class JumppadTool {
    public static Vector calculateLaunchVector(Location jumppadLoc, Location landingLoc, double powerMultiplier) {
        Vector displacement = landingLoc.toVector().subtract(jumppadLoc.toVector());
        Vector horizontalDir = new Vector(displacement.getX(), 0.0, displacement.getZ());
        double horizontalDist = horizontalDir.length();
        if (horizontalDist < 0.1) {
            return new Vector(0.0, Math.max(0.5, Math.abs(displacement.getY()) * 0.5) * powerMultiplier, 0.0);
        }
        horizontalDir.normalize();
        Vector horizontalVec = horizontalDir.clone().multiply(powerMultiplier);
        double minY = -1.0 * powerMultiplier;
        double maxY = 3.0 * powerMultiplier;
        double yStep = 0.01 * powerMultiplier;
        int maxIterations = (int)Math.ceil((maxY - minY) / yStep);
        double MARGIN_OF_ERROR = 1.0;
        for (int i = 0; i <= maxIterations; ++i) {
            Vector landPos;
            double error;
            double yComponent = minY + (double)i * yStep;
            Vector launchVec = horizontalVec.clone();
            launchVec.setY(yComponent);
            ArrayList<Vector> trajectory = MiscUtil.calculateTrajectory(jumppadLoc, launchVec);
            if (trajectory.isEmpty()) continue;
            if (trajectory.size() < 32) {
                JumppadTool.visualizeTrajectory(jumppadLoc, launchVec, Color.fromRGB((int)0xFF0000), false, 4);
            }
            if (!((error = (landPos = trajectory.get(trajectory.size() - 1)).distance(landingLoc.toVector())) <= 1.0)) continue;
            return launchVec;
        }
        return null;
    }

    public static void visualizeTrajectory(Location jumppadLoc, Vector launchVec, Color color, int durationTicks) {
        ArrayList<Vector> trajectory = MiscUtil.calculateTrajectory(jumppadLoc, launchVec);
        Location prevLoc = null;
        for (int i = 0; i < trajectory.size(); ++i) {
            Vector vector = trajectory.get(i);
            Location loc = vector.toLocation(jumppadLoc.getWorld());
            if (prevLoc == null) {
                jumppadLoc.getWorld().spawnParticle(Particle.TRAIL, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(loc, color, durationTicks));
            } else {
                WeaponUtil.spawnParticlesLine(prevLoc, loc, 8.0, particleLocation -> loc.getWorld().spawnParticle(Particle.TRAIL, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(particleLocation, color, durationTicks), true));
            }
            prevLoc = loc;
        }
    }

    public static void visualizeTrajectory(Location jumppadLoc, Vector launchVec, Color color, boolean precise, int durationTicks) {
        ArrayList<Vector> trajectory = MiscUtil.calculateTrajectory(jumppadLoc, launchVec);
        Location prevLoc = null;
        for (int i = 0; i < trajectory.size(); ++i) {
            Vector vector = trajectory.get(i);
            Location loc = vector.toLocation(jumppadLoc.getWorld());
            if (prevLoc == null) {
                jumppadLoc.getWorld().spawnParticle(Particle.TRAIL, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(loc, color, durationTicks));
            } else if (precise) {
                WeaponUtil.spawnParticlesLine(prevLoc, loc, 8.0, particleLocation -> loc.getWorld().spawnParticle(Particle.TRAIL, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(particleLocation, color, durationTicks), true));
            } else {
                loc.getWorld().spawnParticle(Particle.TRAIL, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(loc, color, durationTicks), true);
            }
            prevLoc = loc;
        }
    }

    public static void displayJumppadInfo(Player player, Jumppad jumppad) {
        Vector launchVec;
        Location loc = jumppad.getLocation();
        ArrayList<Vector> trajectory = MiscUtil.calculateTrajectory(loc, launchVec = jumppad.getLaunchVec());
        Vector landingPos = trajectory.isEmpty() ? loc.toVector() : trajectory.get(trajectory.size() - 1);
        player.showTitle(Title.title((Component)Component.empty(), (Component)TranslationManager.t("mapper.tool.jumppad.subtitle.landing", player, new TagResolver[]{Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", landingPos.getX(), landingPos.getY(), landingPos.getZ()))}), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(200L))));
    }

    public static void displayPowerMultiplier(Player player, double powerMultiplier) {
        player.showTitle(Title.title((Component)Component.empty(), (Component)TranslationManager.t("mapper.tool.jumppad.subtitle.power", player, new TagResolver[]{Placeholder.unparsed((String)"power", (String)String.format("%.1f", powerMultiplier))}), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(200L))));
    }
}

