/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.mapper;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.combat.WeaponUtil;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.misc.TranslationManager;
import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class EntityTool {
    public static Trigger getTargetEntity(Player player) {
        Location eyeLocation = player.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        double maxDistance = 10.0;
        Trigger closestTrigger = null;
        double closestDistance = maxDistance;
        for (Trigger trigger : QuakePlugin.INSTANCE.triggers) {
            double distance;
            BoundingBox offsetBox = trigger.getOffsetBoundingBox();
            if (offsetBox == null) continue;
            Location entityLoc = trigger.getLocation();
            Vector entityPos = entityLoc.toVector();
            BoundingBox worldBox = offsetBox.clone().shift(entityPos);
            RayTraceResult rayTrace = worldBox.rayTrace(eyeLocation.toVector(), direction, maxDistance);
            if (rayTrace == null || !((distance = eyeLocation.toVector().distance(rayTrace.getHitPosition())) < closestDistance)) continue;
            closestDistance = distance;
            closestTrigger = trigger;
        }
        return closestTrigger;
    }

    public static void displayEntityInfo(Player player, Trigger trigger) {
        if (trigger == null) {
            player.showTitle(Title.title((Component)Component.empty(), (Component)Component.text((String)TranslationManager.tLegacy("mapper.tool.entity.subtitle.noEntity", player)).color((TextColor)NamedTextColor.GRAY), (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(200L))));
            return;
        }
        Entity entity = trigger.getEntity();
        String entityType = QEntityUtil.getEntityType(entity);
        Location loc = trigger.getLocation();
        Component subtitle = TranslationManager.t("mapper.tool.entity.subtitle.entityInfo", player, new TagResolver[]{Placeholder.unparsed((String)"entity_type", (String)(entityType != null ? entityType : "unknown")), Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))});
        player.showTitle(Title.title((Component)Component.empty(), (Component)subtitle, (Title.Times)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(200L))));
    }

    public static void removeEntity(Player player, Trigger trigger) {
        if (trigger == null) {
            player.sendMessage(TranslationManager.t("mapper.tool.entity.message.noEntity", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
            return;
        }
        String entityType = QEntityUtil.getEntityType(trigger.getEntity());
        Location loc = trigger.getLocation();
        trigger.remove();
        QuakePlugin.INSTANCE.triggers.remove(trigger);
        player.sendMessage(TranslationManager.t("mapper.tool.entity.message.removed", player, new TagResolver[]{Placeholder.unparsed((String)"entity_type", (String)(entityType != null ? entityType : "entity")), Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", loc.x(), loc.y(), loc.z()))}).color((TextColor)NamedTextColor.GREEN));
    }

    public static void startMovingEntity(Player player, Trigger trigger) {
        if (trigger == null) {
            player.sendMessage(TranslationManager.t("mapper.tool.entity.message.noEntityMove", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
            return;
        }
        String entityType = QEntityUtil.getEntityType(trigger.getEntity());
        player.sendMessage(TranslationManager.t("mapper.tool.entity.message.startedMoving", player, new TagResolver[]{Placeholder.unparsed((String)"entity_type", (String)(entityType != null ? entityType : "entity"))}).color((TextColor)NamedTextColor.GREEN));
    }

    public static void stopMovingEntity(Player player, Trigger trigger, Location newLocation) {
        if (trigger == null) {
            player.sendMessage(TranslationManager.t("mapper.tool.entity.message.noEntityMoving", player, new TagResolver[0]).color((TextColor)NamedTextColor.RED));
            return;
        }
        Entity entity = trigger.getEntity();
        entity.teleport(newLocation);
        String entityType = QEntityUtil.getEntityType(entity);
        player.sendMessage(TranslationManager.t("mapper.tool.entity.message.placed", player, new TagResolver[]{Placeholder.unparsed((String)"entity_type", (String)(entityType != null ? entityType : "entity")), Placeholder.unparsed((String)"location", (String)String.format("%.1f %.1f %.1f", newLocation.x(), newLocation.y(), newLocation.z()))}).color((TextColor)NamedTextColor.GREEN));
    }

    public static void drawBoundingBox(World world, BoundingBox box, Color color, int duration, double density) {
        Vector min = box.getMin();
        Vector max = box.getMax();
        EntityTool.drawLine(world, min.getX(), min.getY(), min.getZ(), max.getX(), min.getY(), min.getZ(), color, duration, density);
        EntityTool.drawLine(world, max.getX(), min.getY(), min.getZ(), max.getX(), min.getY(), max.getZ(), color, duration, density);
        EntityTool.drawLine(world, max.getX(), min.getY(), max.getZ(), min.getX(), min.getY(), max.getZ(), color, duration, density);
        EntityTool.drawLine(world, min.getX(), min.getY(), max.getZ(), min.getX(), min.getY(), min.getZ(), color, duration, density);
        EntityTool.drawLine(world, min.getX(), max.getY(), min.getZ(), max.getX(), max.getY(), min.getZ(), color, duration, density);
        EntityTool.drawLine(world, max.getX(), max.getY(), min.getZ(), max.getX(), max.getY(), max.getZ(), color, duration, density);
        EntityTool.drawLine(world, max.getX(), max.getY(), max.getZ(), min.getX(), max.getY(), max.getZ(), color, duration, density);
        EntityTool.drawLine(world, min.getX(), max.getY(), max.getZ(), min.getX(), max.getY(), min.getZ(), color, duration, density);
        EntityTool.drawLine(world, min.getX(), min.getY(), min.getZ(), min.getX(), max.getY(), min.getZ(), color, duration, density);
        EntityTool.drawLine(world, max.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), min.getZ(), color, duration, density);
        EntityTool.drawLine(world, max.getX(), min.getY(), max.getZ(), max.getX(), max.getY(), max.getZ(), color, duration, density);
        EntityTool.drawLine(world, min.getX(), min.getY(), max.getZ(), min.getX(), max.getY(), max.getZ(), color, duration, density);
    }

    public static void drawLine(World world, double x1, double y1, double z1, double x2, double y2, double z2, Color color, int duration, double density) {
        Location start = new Location(world, x1, y1, z1);
        Location end = new Location(world, x2, y2, z2);
        WeaponUtil.spawnParticlesLine(start, end, density, loc -> world.spawnParticle(Particle.TRAIL, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.Trail(loc, color, duration), true));
    }

    public static void visualizeTargetEntity(Player player, Trigger trigger) {
        EntityTool.visualizeEntityWithColor(player, trigger, Color.fromRGB((int)0xFF0000));
    }

    public static void visualizeEntityWithColor(Player player, Trigger trigger, Color color) {
        if (trigger == null) {
            return;
        }
        BoundingBox offsetBox = trigger.getOffsetBoundingBox();
        if (offsetBox == null) {
            return;
        }
        Location entityLoc = trigger.getLocation();
        Vector entityPos = entityLoc.toVector();
        BoundingBox worldBox = offsetBox.clone().shift(entityPos);
        EntityTool.drawBoundingBox(player.getWorld(), worldBox, color, 4, 16.0);
    }
}

