/*
 * Decompiled with CFR 0.152.
 */
package com.github.polyzium.quakechasm.game.entities.triggers;

import com.github.polyzium.quakechasm.QuakePlugin;
import com.github.polyzium.quakechasm.game.entities.QEntityUtil;
import com.github.polyzium.quakechasm.game.entities.Trigger;
import com.github.polyzium.quakechasm.misc.MiscUtil;
import com.github.polyzium.quakechasm.misc.ParticleUtil;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Marker;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.joml.Vector3d;

public class Portal
implements Trigger {
    static BoundingBox boundingBox = new BoundingBox(-0.5, 0.0, -0.5, 0.5, 2.0, 0.5);
    Marker marker;
    Location targetLoc;
    BukkitRunnable particleEmitter;

    public Portal(Location loc, Location targetLoc) {
        this.marker = (Marker)loc.getWorld().spawnEntity(loc, EntityType.MARKER);
        this.targetLoc = targetLoc;
        QEntityUtil.setEntityType((Entity)this.marker, "portal");
        byte[] serializedTargetPos = SerializationUtils.serialize((Serializable)this.targetLoc.toVector().toVector3d());
        byte[] serializedTargetDir = SerializationUtils.serialize((Serializable)this.targetLoc.getDirection().toVector3d());
        PersistentDataContainer pdc = this.marker.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "target_pos"), PersistentDataType.BYTE_ARRAY, (Object)serializedTargetPos);
        pdc.set(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "target_dir"), PersistentDataType.BYTE_ARRAY, (Object)serializedTargetDir);
        this.particleEmitter = this.newParticleEmitter();
        this.particleEmitter.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 1L);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    public Portal(Marker marker) {
        this.marker = marker;
        PersistentDataContainer pdc = this.marker.getPersistentDataContainer();
        byte[] targetPosData = (byte[])pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "target_pos"), PersistentDataType.BYTE_ARRAY);
        byte[] targetDirData = (byte[])pdc.get(new NamespacedKey((Plugin)QuakePlugin.INSTANCE, "target_dir"), PersistentDataType.BYTE_ARRAY);
        Vector targetPos = Vector.fromJOML((Vector3d)((Vector3d)SerializationUtils.deserialize(targetPosData)));
        Vector targetDir = Vector.fromJOML((Vector3d)((Vector3d)SerializationUtils.deserialize(targetDirData)));
        this.targetLoc = targetPos.toLocation(marker.getWorld()).setDirection(targetDir);
        this.particleEmitter = this.newParticleEmitter();
        this.particleEmitter.runTaskTimer((Plugin)QuakePlugin.INSTANCE, 0L, 1L);
        QuakePlugin.INSTANCE.triggers.add(this);
    }

    private BukkitRunnable newParticleEmitter() {
        return new BukkitRunnable(){
            int ticks;

            public void run() {
                if (Portal.this.marker.isDead()) {
                    this.cancel();
                    return;
                }
                Location loc = Portal.this.marker.getLocation();
                loc.add(0.0, 1.0, 0.0);
                loc.getWorld().spawnParticle(Particle.PORTAL, loc, 2, 0.25, 0.5, 0.25, 0.25);
                Location loc2 = Portal.this.marker.getLocation();
                loc2.add(0.0, (double)this.ticks / 4.0, 0.0);
                ParticleUtil.drawParticlesCircle(Particle.ELECTRIC_SPARK, loc2, 0.75, 8);
                if (this.ticks >= 8) {
                    this.ticks = 0;
                }
                ++this.ticks;
            }
        };
    }

    @Override
    public void onTrigger(Entity entity) {
        entity.teleport(this.targetLoc);
        MiscUtil.teleEffect(this.marker.getLocation(), true);
        MiscUtil.teleEffect(this.targetLoc, false);
    }

    @Override
    public void onUnload() {
        this.particleEmitter.cancel();
    }

    @Override
    public Location getLocation() {
        return this.marker.getLocation();
    }

    @Override
    public Entity getEntity() {
        return this.marker;
    }

    @Override
    public BoundingBox getOffsetBoundingBox() {
        return boundingBox;
    }

    @Override
    public void remove() {
        this.onUnload();
        this.marker.remove();
    }
}

